/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Anti;

import dev.atrox.lightchat.HexColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class AntiLongRepeatedChars
implements Listener {
    private boolean antiLongRepeatedCharsEnabled;
    private int maxRepeatedChars;
    private boolean opsBypassAntiLongRepeatedChars;
    private String warningMessage;

    public AntiLongRepeatedChars(FileConfiguration config) {
        this.reloadConfig(config);
    }

    public void reloadConfig(FileConfiguration config) {
        this.antiLongRepeatedCharsEnabled = config.getBoolean("AntiLongRepeatedChars", true);
        this.maxRepeatedChars = config.getInt("MaxRepeatedChars", 3);
        this.opsBypassAntiLongRepeatedChars = config.getBoolean("ops_bypass_anti_long_repeated_chars", true);
        this.warningMessage = HexColor.translateAlternateColorCodes('&', config.getString("warning-message", "&b\u029f\u026a\u0262\u029c\u1d1b\u1d04\u029c\u1d00\u1d1b\u279c &cPlease avoid using long repeated characters in words!"));
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (!this.antiLongRepeatedCharsEnabled) {
            return;
        }
        Player player = event.getPlayer();
        if (this.opsBypassAntiLongRepeatedChars && player.isOp()) {
            return;
        }
        String message = event.getMessage();
        if (this.containsLongRepeatedChars(message)) {
            event.setCancelled(true);
            player.sendMessage(this.warningMessage);
        }
    }

    private boolean containsLongRepeatedChars(String message) {
        if (message.isEmpty()) {
            return false;
        }
        char lastChar = message.charAt(0);
        int count = 1;
        for (int i = 1; i < message.length(); ++i) {
            char currentChar = message.charAt(i);
            if (currentChar == lastChar) {
                if (++count < this.maxRepeatedChars) continue;
                return true;
            }
            lastChar = currentChar;
            count = 1;
        }
        return false;
    }
}

