/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Anti;

import dev.atrox.lightchat.HexColor;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class AntiSpam
implements Listener {
    private final Map<UUID, Long> lastMessageTime = new HashMap<UUID, Long>();
    private int spamCooldownSeconds;
    private String cooldownMessage;
    private boolean opsBypassAntiSpam;

    public AntiSpam(FileConfiguration config) {
        this.reloadConfig(config);
    }

    public void reloadConfig(FileConfiguration config) {
        this.spamCooldownSeconds = config.getInt("spam_cooldown_seconds", 2);
        this.cooldownMessage = config.getString("cooldown_message", "&b\u029f\u026a\u0262\u029c\u1d1b\u1d04\u029c\u1d00\u1d1b\u279c &cPlease wait %cooldown_seconds% seconds before sending another message.");
        this.opsBypassAntiSpam = config.getBoolean("ops_bypass_anti_spam", true);
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        long lastMessage = this.lastMessageTime.getOrDefault(playerId, 0L);
        long spamCooldownMillis = (long)this.spamCooldownSeconds * 1000L;
        if (this.opsBypassAntiSpam && player.isOp()) {
            return;
        }
        long timeLeftMillis = spamCooldownMillis - (currentTime - lastMessage);
        if (timeLeftMillis > 0L) {
            event.setCancelled(true);
            long timeLeftSeconds = (long)Math.ceil((double)timeLeftMillis / 1000.0);
            String formattedMessage = this.cooldownMessage.replace("%cooldown_seconds%", String.valueOf(timeLeftSeconds));
            player.sendMessage(HexColor.translateAlternateColorCodes('&', formattedMessage));
        } else {
            this.lastMessageTime.put(playerId, currentTime);
        }
    }
}

