/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Anti;

import dev.atrox.lightchat.Anti.EmbedField;
import dev.atrox.lightchat.HexColor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class AntiSwear
implements Listener {
    private FileConfiguration config;
    private FileConfiguration pluginConfig;
    private List<String> swearWords;
    private String swearMessage;
    private String webhookUrl;
    private boolean webhookEnabled;
    private String embedTitle;
    private String embedColor;
    private List<EmbedField> embedFields;
    private File configFile;

    public AntiSwear(JavaPlugin plugin) {
        this.pluginConfig = plugin.getConfig();
        this.loadConfig(plugin);
    }

    public void loadConfig(JavaPlugin plugin) {
        this.configFile = new File(plugin.getDataFolder(), "antiswear.yml");
        if (!this.configFile.exists()) {
            plugin.saveResource("antiswear.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.reloadConfig();
    }

    public void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.swearWords = this.config.getStringList("swear_words");
        this.swearMessage = this.pluginConfig.getString("swear_message", "&b\u029f\u026a\u0262\u029c\u1d1b\u1d04\u029c\u1d00\u1d1b\u279c &cPlease do not use inappropriate language.");
        this.webhookUrl = this.config.getString("webhook_url");
        this.webhookEnabled = this.config.getBoolean("webhook_enabled", false);
        this.embedTitle = this.config.getString("embed_title", "Swear Word Detected");
        this.embedColor = this.config.getString("embed_color", "FF0000");
        this.embedFields = this.config.getStringList("embed_fields").stream().map(field -> {
            String[] parts = field.split(",");
            return new EmbedField(parts[0], parts[1]);
        }).collect(Collectors.toList());
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        String message = event.getMessage();
        Player player = event.getPlayer();
        for (String swearWord : this.swearWords) {
            String regex = "\\b" + Pattern.quote(swearWord) + "\\b";
            Pattern pattern = Pattern.compile(regex, 2);
            if (!pattern.matcher(message).find()) continue;
            event.setCancelled(true);
            player.sendMessage(HexColor.translateAlternateColorCodes('&', this.swearMessage));
            if (this.webhookEnabled) {
                this.sendWebhookMessage(player, message);
            }
            return;
        }
    }

    private void sendWebhookMessage(Player player, String message) {
        if (this.webhookUrl.isEmpty() || !this.webhookUrl.startsWith("http")) {
            return;
        }
        try {
            URL url = new URL(this.webhookUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/json");
            String jsonPayload = "{\"embeds\": [{\"title\": \"" + this.embedTitle + "\",\"fields\": [";
            for (EmbedField field : this.embedFields) {
                jsonPayload = jsonPayload + "{\"name\": \"" + field.getName() + "\", \"value\": \"" + this.getFieldReplacement(field, player, message) + "\", \"inline\": true},";
            }
            jsonPayload = jsonPayload.substring(0, jsonPayload.length() - 1);
            jsonPayload = jsonPayload + "],\"color\": " + Integer.parseInt(this.embedColor, 16) + "}]}";
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = jsonPayload.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            int responseCode = connection.getResponseCode();
            if (responseCode != 204 && responseCode != 200) {
                System.out.println("Failed to send webhook message. Response code: " + responseCode);
            }
        }
        catch (Exception e) {
            System.out.println("Failed to send webhook message: " + e.getMessage());
        }
    }

    private String getFieldReplacement(EmbedField field, Player player, String message) {
        switch (field.getName()) {
            case "Player": {
                return player.getName();
            }
            case "Message": {
                return message;
            }
        }
        return "";
    }
}

