/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Anti;

import dev.atrox.lightchat.HexColor;
import java.io.File;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class BlockCommand
implements Listener {
    private final JavaPlugin plugin;
    private List<String> blockedCommands;
    private String blockMessage;
    private boolean sendBlockMessage;

    public BlockCommand(JavaPlugin plugin) {
        this.plugin = plugin;
        this.reloadConfig();
    }

    public void reloadConfig() {
        File file = new File(this.plugin.getDataFolder(), "blockcommand.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        this.blockedCommands = config.getStringList("blocked-commands");
        String rawMessage = config.getString("block-message", "&cYou cannot use this command!");
        this.blockMessage = HexColor.translateAlternateColorCodes('&', rawMessage);
        this.sendBlockMessage = config.getBoolean("send-block-message", false);
    }

    @EventHandler
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        String message = event.getMessage().toLowerCase();
        for (String blockedCommand : this.blockedCommands) {
            if (!message.startsWith("/" + blockedCommand.toLowerCase())) continue;
            event.setCancelled(true);
            if (this.sendBlockMessage) {
                event.getPlayer().sendMessage(this.blockMessage);
            }
            return;
        }
    }
}

