/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Chat;

import dev.atrox.lightchat.HexColor;
import dev.atrox.lightchat.LightChat;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChatClear
implements CommandExecutor {
    private static final int MAX_MESSAGES = 100;
    private final LightChat plugin;

    public ChatClear(LightChat plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("lightchat.chatclear")) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', "&cYou do not have permission to use this command!"));
            return true;
        }
        this.clearChatForAllPlayers();
        String clearMessage = this.plugin.getConfig().getString("chat_clear_message", "&b\u029f\u026a\u0262\u029c\u1d1b\u1d04\u029c\u1d00\u1d1b\u279c &eChat has been cleared by %player%!");
        clearMessage = HexColor.translateAlternateColorCodes('&', clearMessage);
        if (sender instanceof Player) {
            Player player = (Player)sender;
            clearMessage = clearMessage.replace("%player%", player.getName());
        } else {
            clearMessage = clearMessage.replace("%player%", "Console");
        }
        Bukkit.broadcastMessage((String)clearMessage);
        return true;
    }

    private void clearChatForAllPlayers() {
        Collection players = Bukkit.getServer().getOnlinePlayers();
        for (Player player : players) {
            for (int i = 0; i < 100; ++i) {
                player.sendMessage("");
            }
        }
    }
}

