/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Chat;

import dev.atrox.lightchat.HexColor;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ChatDisable
implements CommandExecutor,
Listener {
    private final JavaPlugin plugin;

    public ChatDisable(JavaPlugin plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("lightchat.chatdisable")) {
            player.sendMessage(ChatColor.RED + "You do not have permission to use this command!");
            return true;
        }
        FileConfiguration config = this.plugin.getConfig();
        config.set("chat_enabled", (Object)false);
        this.plugin.saveConfig();
        String playerName = player.getName();
        String disableMessage = config.getString("chat_disable_message", "&b\u029f\u026a\u0262\u029c\u1d1b\u1d04\u029c\u1d00\u1d1b\u279c &cChat has been muted by %player%");
        disableMessage = HexColor.translateAlternateColorCodes('&', disableMessage.replace("%player%", playerName));
        this.plugin.getServer().broadcastMessage(disableMessage);
        return true;
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (!this.plugin.getConfig().getBoolean("chat_enabled", true) && !player.hasPermission("lightchat.bypass.chatdisable")) {
            event.setCancelled(true);
            String disableMessage = this.plugin.getConfig().getString("chat_disable_message", "&bLightChat>> &cChat has been muted.");
            disableMessage = HexColor.translateAlternateColorCodes('&', disableMessage);
            player.sendMessage(disableMessage);
        }
    }
}

