/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Chat;

import dev.atrox.lightchat.HexColor;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class ChatEnable
implements CommandExecutor {
    private final JavaPlugin plugin;

    public ChatEnable(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("lightchat.chatenable")) {
            player.sendMessage(ChatColor.RED + "You do not have permission to use this command!");
            return true;
        }
        FileConfiguration config = this.plugin.getConfig();
        config.set("chat_enabled", (Object)true);
        String enableMessage = config.getString("chat_enable_message", "&b\u029f\u026a\u0262\u029c\u1d1b\u1d04\u029c\u1d00\u1d1b\u279c &aChat has been enabled by %player%");
        enableMessage = HexColor.translateAlternateColorCodes('&', enableMessage.replace("%player%", player.getName()));
        this.plugin.saveConfig();
        this.plugin.getServer().broadcastMessage(enableMessage);
        return true;
    }
}

