/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Chat;

import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.ItemTag;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Item;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.ItemStack;

public class ChatItems
implements Listener {
    private final String itemPlaceholder;

    public ChatItems(FileConfiguration config) {
        this.itemPlaceholder = config.getString("placeholders.item", "[items]");
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        ItemStack item;
        Player player = event.getPlayer();
        String message = event.getMessage();
        if (message.contains(this.itemPlaceholder) && (item = player.getInventory().getItemInMainHand()) != null && item.getType() != Material.AIR) {
            String displayName = item.getItemMeta() != null && item.getItemMeta().hasDisplayName() ? item.getItemMeta().getDisplayName() : item.getType().toString();
            ItemTag itemTag = ItemTag.ofNbt((String)item.getItemMeta().getAsString());
            Item itemInfo = new Item(item.getType().getKey().toString(), item.getAmount(), itemTag);
            TextComponent itemComponent = new TextComponent(displayName + " (x" + item.getAmount() + ")");
            itemComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, new Content[]{itemInfo}));
            String[] splitMessage = message.split(this.itemPlaceholder);
            TextComponent finalMessage = new TextComponent("");
            for (int i = 0; i < splitMessage.length; ++i) {
                finalMessage.addExtra((BaseComponent)new TextComponent(splitMessage[i]));
                if (i >= splitMessage.length - 1) continue;
                finalMessage.addExtra((BaseComponent)itemComponent);
            }
            for (Player onlinePlayer : event.getRecipients()) {
                onlinePlayer.spigot().sendMessage((BaseComponent)finalMessage);
            }
            event.setCancelled(true);
        }
    }
}

