/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Chat;

import dev.atrox.lightchat.HexColor;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ToggleChat
implements CommandExecutor,
Listener {
    private final JavaPlugin plugin;
    private final Set<Player> chatDisabledPlayers = new HashSet<Player>();

    public ToggleChat(JavaPlugin plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', "&cThis command can only be used by players!"));
            return true;
        }
        Player player = (Player)sender;
        FileConfiguration config = this.plugin.getConfig();
        if (!player.hasPermission("lightchat.togglechat")) {
            player.sendMessage(HexColor.translateAlternateColorCodes('&', "&cYou do not have permission to use this command!"));
            return true;
        }
        if (this.chatDisabledPlayers.contains(player)) {
            this.chatDisabledPlayers.remove(player);
            String enableMessage = config.getString("chat_enabled_message", "&aChat has been enabled for you.");
            player.sendMessage(HexColor.translateAlternateColorCodes('&', enableMessage));
        } else {
            this.chatDisabledPlayers.add(player);
            String disableMessage = config.getString("chat_disabled_message", "&cChat has been disabled for you.");
            player.sendMessage(HexColor.translateAlternateColorCodes('&', disableMessage));
        }
        return true;
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        Player sender = event.getPlayer();
        FileConfiguration config = this.plugin.getConfig();
        event.getRecipients().removeIf(this.chatDisabledPlayers::contains);
        if (this.chatDisabledPlayers.contains(sender)) {
            event.setCancelled(true);
            String chatBlockedMessage = config.getString("chat_blocked_message", "&cYou cannot send messages while your chat is disabled.");
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', chatBlockedMessage));
        }
    }
}

