/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Commands;

import dev.atrox.lightchat.HexColor;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class ActionBarCommand
implements CommandExecutor,
TabCompleter {
    private final JavaPlugin plugin;

    public ActionBarCommand(JavaPlugin plugin) {
        this.plugin = plugin;
        plugin.getCommand("actionbar").setExecutor((CommandExecutor)this);
        plugin.getCommand("actionbar").setTabCompleter((TabCompleter)this);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("lightchat.actionbar")) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', "&cYou don't have permission to use this command."));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', "&cUsage: /actionbar <all|player> <message>"));
            return false;
        }
        String target = args[0];
        String message = String.join((CharSequence)" ", args).substring(target.length() + 1);
        if (target.equalsIgnoreCase("all")) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.sendActionBar(player, message);
            }
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', "&aAction bar message sent to all players."));
        } else {
            Player player = Bukkit.getPlayer((String)target);
            if (player != null) {
                this.sendActionBar(player, message);
                sender.sendMessage(HexColor.translateAlternateColorCodes('&', "&aAction bar message sent to " + player.getName()));
            } else {
                sender.sendMessage(HexColor.translateAlternateColorCodes('&', "&cPlayer not found."));
            }
        }
        return true;
    }

    private void sendActionBar(Player player, String message) {
        String formattedMessage = HexColor.translateAlternateColorCodes('&', message);
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(formattedMessage));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.add("all");
            for (Player player : Bukkit.getOnlinePlayers()) {
                completions.add(player.getName());
            }
        }
        return completions;
    }
}

