/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Commands;

import dev.atrox.lightchat.HexColor;
import dev.atrox.lightchat.LightChat;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AnnounceCommand
implements CommandExecutor {
    private final LightChat plugin;

    public AnnounceCommand(LightChat plugin) {
        this.plugin = plugin;
        plugin.getCommand("announce").setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', "&cUsage: /announce <message>"));
            return true;
        }
        String title = this.plugin.getConfig().getString("announce-title", "&eAnnouncement");
        String subtitle = this.plugin.getConfig().getString("announce-subtitle", "&bCheck the chat for details!");
        String prefix = this.plugin.getConfig().getString("announce-prefix", "&a[Announcer]");
        String soundName = this.plugin.getConfig().getString("announce-sound", "ENTITY_PLAYER_LEVELUP");
        Sound sound = Sound.valueOf((String)soundName.toUpperCase());
        String message = String.join((CharSequence)" ", args);
        String formattedTitle = HexColor.translateAlternateColorCodes('&', title);
        String formattedSubtitle = HexColor.translateAlternateColorCodes('&', subtitle);
        String formattedPrefix = HexColor.translateAlternateColorCodes('&', prefix);
        String formattedMessage = formattedPrefix + " " + HexColor.translateAlternateColorCodes('&', message);
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendTitle(formattedTitle, formattedSubtitle, 10, 70, 20);
            player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
        }
        this.plugin.getServer().broadcastMessage(formattedMessage);
        return true;
    }
}

