/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Commands;

import dev.atrox.lightchat.Commands.DoNotDisturb;
import dev.atrox.lightchat.Commands.ReplyCommand;
import dev.atrox.lightchat.HexColor;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class MsgCommand
implements CommandExecutor {
    private final JavaPlugin plugin;

    public MsgCommand(JavaPlugin plugin) {
        this.plugin = plugin;
        plugin.getCommand("msg").setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', "&cOnly players can use this command!"));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', "&cUsage: /msg <player> <message>"));
            return true;
        }
        Player playerSender = (Player)sender;
        Player recipient = this.plugin.getServer().getPlayer(args[0]);
        if (recipient == null || !recipient.isOnline()) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', "&cPlayer is not online or could not be found!"));
            return true;
        }
        if (DoNotDisturb.isInDoNotDisturb(recipient)) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', "&cThe player is in Do Not Disturb mode and will not receive your message."));
            return true;
        }
        StringBuilder messageBuilder = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            if (i > 1) {
                messageBuilder.append(" ");
            }
            messageBuilder.append(args[i]);
        }
        String message = HexColor.translateAlternateColorCodes('&', messageBuilder.toString());
        FileConfiguration config = this.plugin.getConfig();
        String sentFormat = HexColor.translateAlternateColorCodes('&', config.getString("msg_format.sent", "&7[&aYou \u2192 %recipient%&7] &f%message%"));
        String receivedFormat = HexColor.translateAlternateColorCodes('&', config.getString("msg_format.received", "&7[&a%sender% \u2192 You&7] &f%message%"));
        String notificationSound = config.getString("msg_notification.sound", "ENTITY_EXPERIENCE_ORB_PICKUP").toUpperCase();
        String senderName = playerSender.getDisplayName();
        String recipientName = recipient.getDisplayName();
        String formattedSentMessage = sentFormat.replace("%sender%", senderName).replace("%recipient%", recipientName).replace("%message%", message);
        String formattedReceivedMessage = receivedFormat.replace("%sender%", senderName).replace("%message%", message);
        playerSender.sendMessage(formattedSentMessage);
        recipient.sendMessage(formattedReceivedMessage);
        ReplyCommand.setLastMessageSender(recipient, playerSender);
        try {
            Sound sound = Sound.valueOf((String)notificationSound);
            recipient.playSound(recipient.getLocation(), sound, 1.0f, 1.0f);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid notification sound setting: " + notificationSound);
        }
        return true;
    }
}

