/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Commands;

import dev.atrox.lightchat.Commands.Utils;
import dev.atrox.lightchat.HexColor;
import dev.atrox.lightchat.LightChat;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PingCommand
implements CommandExecutor {
    private final LightChat plugin;

    public PingCommand(LightChat plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        int ping = Utils.getPlayerPing(player);
        if (ping == -1) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', "&cAn error occurred while retrieving ping."));
        } else {
            String pingMessage = this.getPingMessage(ping);
            sender.sendMessage(pingMessage);
        }
        return true;
    }

    private String getPingMessage(int ping) {
        String message = ping <= 60 ? this.plugin.getConfig().getString("pingMessages.green", "&aYour ping: %ping%ms") : (ping <= 160 ? this.plugin.getConfig().getString("pingMessages.yellow", "&eYour ping: %ping%ms") : (ping <= 300 ? this.plugin.getConfig().getString("pingMessages.orange", "&6Your ping: %ping%ms") : this.plugin.getConfig().getString("pingMessages.red", "&cYour ping: %ping%ms")));
        return HexColor.translateAlternateColorCodes('&', message.replace("%ping%", String.valueOf(ping)));
    }
}

