/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Commands;

import dev.atrox.lightchat.Anti.AntiAdvertising;
import dev.atrox.lightchat.Anti.AntiLongRepeatedChars;
import dev.atrox.lightchat.Anti.AntiSpam;
import dev.atrox.lightchat.Anti.AntiSwear;
import dev.atrox.lightchat.Anti.AntiTabComplete;
import dev.atrox.lightchat.Anti.BlockCommand;
import dev.atrox.lightchat.HexColor;
import dev.atrox.lightchat.LightChat;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ReloadCommand
implements CommandExecutor {
    private final LightChat plugin;
    private final AntiSwear antiSwear;
    private final AntiSpam antiSpam;
    private final AntiLongRepeatedChars antiLongRepeatedChars;
    private final AntiAdvertising antiAdvertising;
    private final AntiTabComplete antiTabComplete;
    private final BlockCommand blockCommand;

    public ReloadCommand(LightChat plugin, AntiSwear antiSwear, AntiSpam antiSpam, AntiLongRepeatedChars antiLongRepeatedChars, AntiAdvertising antiAdvertising, AntiTabComplete antiTabComplete, BlockCommand blockCommand) {
        this.plugin = plugin;
        this.antiSwear = antiSwear;
        this.antiSpam = antiSpam;
        this.antiLongRepeatedChars = antiLongRepeatedChars;
        this.antiAdvertising = antiAdvertising;
        this.antiTabComplete = antiTabComplete;
        this.blockCommand = blockCommand;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender.hasPermission("lightchat.reload")) {
            long startTime = System.currentTimeMillis();
            this.plugin.reloadConfigs();
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', "&aLightChat configuration reloaded in " + duration + " ms"));
            if (sender instanceof Player) {
                Player player = (Player)sender;
                player.playSound(player.getLocation(), this.plugin.getConfig().getString("reload-sound"), 1.0f, 1.0f);
            }
        } else {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', "&cYou do not have permission to use this command."));
        }
        return true;
    }
}

