/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Commands;

import dev.atrox.lightchat.HexColor;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class TitleCommand
implements CommandExecutor,
TabCompleter {
    private final JavaPlugin plugin;

    public TitleCommand(JavaPlugin plugin) {
        this.plugin = plugin;
        plugin.getCommand("title").setExecutor((CommandExecutor)this);
        plugin.getCommand("title").setTabCompleter((TabCompleter)this);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', "&cOnly players can use this command!"));
            return true;
        }
        if (!sender.hasPermission("lightchat.title")) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', "&cYou don't have permission to use this command."));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', "&cUsage: /title <all|player> <message>"));
            return false;
        }
        String target = args[0];
        StringBuilder titleBuilder = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            titleBuilder.append(args[i]).append(" ");
        }
        String title = HexColor.translateAlternateColorCodes('&', titleBuilder.toString().trim());
        if (target.equalsIgnoreCase("all")) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.sendTitle(player, title);
            }
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', "&aTitle sent to all players."));
        } else {
            Player player = Bukkit.getPlayer((String)target);
            if (player != null) {
                this.sendTitle(player, title);
                sender.sendMessage(HexColor.translateAlternateColorCodes('&', "&aTitle sent to " + player.getName()));
            } else {
                sender.sendMessage(HexColor.translateAlternateColorCodes('&', "&cPlayer not found."));
            }
        }
        return true;
    }

    private void sendTitle(Player player, String title) {
        player.sendTitle(title, "", 10, 70, 20);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.add("all");
            for (Player player : Bukkit.getOnlinePlayers()) {
                completions.add(player.getName());
            }
        }
        return completions;
    }
}

