/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat;

import dev.atrox.lightchat.Anti.AntiAdvertising;
import dev.atrox.lightchat.Anti.AntiCaps;
import dev.atrox.lightchat.Anti.AntiLongRepeatedChars;
import dev.atrox.lightchat.Anti.AntiSpam;
import dev.atrox.lightchat.Anti.AntiSwear;
import dev.atrox.lightchat.Anti.AntiTabComplete;
import dev.atrox.lightchat.Anti.BlockCommand;
import dev.atrox.lightchat.Chat.ChatClear;
import dev.atrox.lightchat.Chat.ChatDisable;
import dev.atrox.lightchat.Chat.ChatEnable;
import dev.atrox.lightchat.Chat.Mention;
import dev.atrox.lightchat.Chat.PlayerChatClear;
import dev.atrox.lightchat.Chat.ToggleChat;
import dev.atrox.lightchat.Commands.ActionBarCommand;
import dev.atrox.lightchat.Commands.AnnounceCommand;
import dev.atrox.lightchat.Commands.BroadCastCommand;
import dev.atrox.lightchat.Commands.DNDPlaceholderExpansion;
import dev.atrox.lightchat.Commands.DiscordCommand;
import dev.atrox.lightchat.Commands.DoNotDisturb;
import dev.atrox.lightchat.Commands.MsgCommand;
import dev.atrox.lightchat.Commands.PingCommand;
import dev.atrox.lightchat.Commands.ReloadCommand;
import dev.atrox.lightchat.Commands.ReplyCommand;
import dev.atrox.lightchat.Commands.TitleCommand;
import dev.atrox.lightchat.Commands.WebsiteCommand;
import dev.atrox.lightchat.HelpCommand;
import dev.atrox.lightchat.UpdateChecker.UpdateChecker;
import dev.atrox.lightchat.bstats.bukkit.Metrics;
import dev.atrox.lightchat.joinquit;
import java.io.File;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class LightChat
extends JavaPlugin {
    private AntiSwear antiSwear;
    private AntiSpam antiSpam;
    private AntiLongRepeatedChars antiLongRepeatedChars;
    private AntiAdvertising antiAdvertising;
    private AntiTabComplete antiTabComplete;
    private BlockCommand blockCommand;
    private UpdateChecker updateChecker;

    public void onEnable() {
        this.getConfig().options().copyDefaults(true);
        this.saveDefaultConfig();
        this.loadResource("antiadvertising.yml");
        this.loadResource("antitabcomplete.yml");
        this.loadResource("blockcommand.yml");
        this.antiSwear = new AntiSwear(this);
        FileConfiguration config = this.getConfig();
        this.antiSpam = new AntiSpam(config);
        this.antiLongRepeatedChars = new AntiLongRepeatedChars(config);
        this.antiAdvertising = new AntiAdvertising(this);
        this.antiTabComplete = new AntiTabComplete(this);
        this.blockCommand = new BlockCommand(this);
        int pluginId = 23591;
        Metrics metrics = new Metrics(this, pluginId);
        this.updateChecker = new UpdateChecker(this, 116760);
        this.updateChecker.checkOnStartup();
        this.registerEvents();
        this.registerCommands();
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new DNDPlaceholderExpansion(this).register();
        }
    }

    private void loadResource(String fileName) {
        if (!new File(this.getDataFolder(), fileName).exists()) {
            this.saveResource(fileName, false);
        }
    }

    private void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)this.antiSwear, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new joinquit(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new AntiCaps(this.getConfig()), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.antiSpam, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.antiLongRepeatedChars, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.antiAdvertising, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new Mention(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.antiTabComplete, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.blockCommand, (Plugin)this);
    }

    private void registerCommands() {
        this.getCommand("chatclear").setExecutor((CommandExecutor)new ChatClear(this));
        this.getCommand("chatdisable").setExecutor((CommandExecutor)new ChatDisable(this));
        this.getCommand("chatenable").setExecutor((CommandExecutor)new ChatEnable(this));
        this.getCommand("lightchatreload").setExecutor((CommandExecutor)new ReloadCommand(this, this.antiSwear, this.antiSpam, this.antiLongRepeatedChars, this.antiAdvertising, this.antiTabComplete, this.blockCommand));
        this.getCommand("lightchathelp").setExecutor((CommandExecutor)new HelpCommand());
        this.getCommand("msg").setExecutor((CommandExecutor)new MsgCommand(this));
        this.getCommand("website").setExecutor((CommandExecutor)new WebsiteCommand(this));
        this.getCommand("discord").setExecutor((CommandExecutor)new DiscordCommand(this));
        this.getCommand("ping").setExecutor((CommandExecutor)new PingCommand(this));
        this.getCommand("title").setExecutor((CommandExecutor)new TitleCommand(this));
        this.getCommand("actionbar").setExecutor((CommandExecutor)new ActionBarCommand(this));
        this.getCommand("broadcast").setExecutor((CommandExecutor)new BroadCastCommand(this));
        this.getCommand("announce").setExecutor((CommandExecutor)new AnnounceCommand(this));
        this.getCommand("dnd").setExecutor((CommandExecutor)new DoNotDisturb(this));
        this.getCommand("togglechat").setExecutor((CommandExecutor)new ToggleChat(this));
        this.getCommand("reply").setExecutor((CommandExecutor)new ReplyCommand(this));
        this.getCommand("pchatclear").setExecutor((CommandExecutor)new PlayerChatClear(this));
    }

    public void reloadConfigs() {
        this.reloadConfig();
        this.antiSwear.reloadConfig();
        this.antiSpam.reloadConfig(this.getConfig());
        this.antiLongRepeatedChars.reloadConfig(this.getConfig());
        this.antiAdvertising.reloadConfiguration();
        this.antiTabComplete.reloadConfig();
        this.blockCommand.reloadConfig();
    }
}

