/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Anti;

import dev.atrox.lightchat.LightChat;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class AntiAdvertising
implements Listener {
    private boolean isEnabled;
    private boolean opBypass;
    private String warningMessage;
    private final LightChat plugin;
    private boolean hasWarned = false;
    private boolean checkDomains;
    private boolean checkIPs;
    private boolean checkURLs;
    private List<String> domainPatterns;
    private List<String> ipPatterns;
    private List<String> urlPatterns;

    public AntiAdvertising(LightChat plugin) {
        this.plugin = plugin;
        this.reloadConfiguration();
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (!this.isEnabled) {
            return;
        }
        Player player = event.getPlayer();
        if (player.isOp() ? this.opBypass : player.hasPermission("lightchat.advertising.bypass")) {
            return;
        }
        if (this.hasWarned) {
            return;
        }
        String message = event.getMessage();
        if (this.containsProhibitedContent(message)) {
            event.setCancelled(true);
            player.sendMessage(this.plugin.getPrefixManager().formatMessage("antiadvertising.warning_message"));
            this.hasWarned = true;
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                this.hasWarned = false;
            }, 20L);
        }
    }

    public boolean containsProhibitedContent(String message) {
        if (this.checkIPs && this.containsPattern(message, this.ipPatterns)) {
            return true;
        }
        if (this.checkDomains && this.containsPattern(message, this.domainPatterns)) {
            return true;
        }
        return this.checkURLs && this.containsPattern(message, this.urlPatterns);
    }

    private boolean containsPattern(String message, List<String> patterns) {
        for (String pattern : patterns) {
            try {
                Pattern compiled = Pattern.compile(pattern, 2);
                Matcher matcher = compiled.matcher(message);
                if (!matcher.find()) continue;
                return true;
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Invalid regex pattern: " + pattern);
            }
        }
        return false;
    }

    public void reloadConfiguration() {
        File configFile = new File(this.plugin.getDataFolder(), "antiadvertising.yml");
        if (!configFile.exists()) {
            this.plugin.saveResource("antiadvertising.yml", false);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        YamlConfiguration messages = YamlConfiguration.loadConfiguration((File)messagesFile);
        this.isEnabled = config.getBoolean("enabled", true);
        this.opBypass = config.getBoolean("op-bypass", true);
        this.warningMessage = this.plugin.getPrefixManager().formatMessage("antiadvertising.warning_message");
        this.checkDomains = config.getBoolean("detection.domains.enabled", true);
        this.checkIPs = config.getBoolean("detection.ips.enabled", true);
        this.checkURLs = config.getBoolean("detection.urls.enabled", true);
        this.domainPatterns = config.getStringList("detection.domains.patterns");
        this.ipPatterns = config.getStringList("detection.ips.patterns");
        this.urlPatterns = config.getStringList("detection.urls.patterns");
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public void reloadConfig() {
        this.reloadConfiguration();
    }
}

