/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Anti;

import dev.atrox.lightchat.LightChat;
import java.io.File;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class AntiLongRepeatedChars
implements Listener {
    private boolean antiLongRepeatedCharsEnabled;
    private int maxRepeatedChars;
    private boolean opsBypassAntiLongRepeatedChars;
    private String warningMessage;
    private FileConfiguration messages;
    private final LightChat plugin;

    public AntiLongRepeatedChars(LightChat plugin) {
        this.plugin = plugin;
        this.reloadConfig();
    }

    public void reloadConfig() {
        FileConfiguration config = this.plugin.getConfig();
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
        this.antiLongRepeatedCharsEnabled = config.getBoolean("AntiLongRepeatedChars", true);
        this.maxRepeatedChars = config.getInt("MaxRepeatedChars", 3);
        this.opsBypassAntiLongRepeatedChars = config.getBoolean("ops_bypass_anti_long_repeated_chars", true);
        this.warningMessage = this.plugin.getPrefixManager().formatMessage("antilongrepeatedchars-warning");
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (!this.antiLongRepeatedCharsEnabled) {
            return;
        }
        Player player = event.getPlayer();
        if (this.opsBypassAntiLongRepeatedChars && player.isOp()) {
            return;
        }
        String message = event.getMessage();
        if (this.containsLongRepeatedChars(message)) {
            event.setCancelled(true);
            player.sendMessage(this.warningMessage);
        }
    }

    private boolean containsLongRepeatedChars(String message) {
        if (message.isEmpty()) {
            return false;
        }
        char lastChar = message.charAt(0);
        int count = 1;
        for (int i = 1; i < message.length(); ++i) {
            char currentChar = message.charAt(i);
            if (currentChar == lastChar) {
                if (++count < this.maxRepeatedChars) continue;
                return true;
            }
            lastChar = currentChar;
            count = 1;
        }
        return false;
    }
}

