/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Anti;

import dev.atrox.lightchat.HexColor;
import dev.atrox.lightchat.LightChat;
import java.io.File;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class AntiSpaceSpam
implements Listener {
    private final LightChat plugin;
    private FileConfiguration messagesConfig;
    private boolean blockEnabled;
    private double maxSpacePercentage;
    private boolean opBypass;
    private String warningMessage;
    private String blockMessage;

    public AntiSpaceSpam(LightChat plugin) {
        this.plugin = plugin;
        this.loadConfigs();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private void loadConfigs() {
        this.plugin.saveDefaultConfig();
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.plugin.saveResource("config.yml", false);
        }
        this.plugin.reloadConfig();
        this.blockEnabled = this.plugin.getConfig().getBoolean("anti-space-spam.block", true);
        this.maxSpacePercentage = this.plugin.getConfig().getDouble("anti-space-spam.max-space-percentage", 20.0);
        this.opBypass = this.plugin.getConfig().getBoolean("anti-space-spam.op-bypass", true);
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
        this.warningMessage = this.plugin.getPrefixManager().formatMessage("anti-space-spam-warning");
        this.blockMessage = this.plugin.getPrefixManager().formatMessage("anti-space-spam-blocked");
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        if (this.opBypass && player.isOp()) {
            return;
        }
        if (player.hasPermission("lightchat.antispacespam.bypass")) {
            return;
        }
        String message = event.getMessage();
        int totalChars = message.length();
        if (totalChars == 0) {
            return;
        }
        int spaceCount = 0;
        for (char c : message.toCharArray()) {
            if (c != ' ') continue;
            ++spaceCount;
        }
        double spacePercentage = (double)spaceCount * 100.0 / (double)totalChars;
        if (spacePercentage > this.maxSpacePercentage) {
            String formattedWarning = this.warningMessage.replace("%percentage%", String.format("%.1f", spacePercentage));
            String formattedBlock = this.blockMessage.replace("%percentage%", String.format("%.1f", spacePercentage));
            player.sendMessage(HexColor.translateAlternateColorCodes('&', formattedWarning));
            if (this.blockEnabled) {
                event.setCancelled(true);
                player.sendMessage(HexColor.translateAlternateColorCodes('&', formattedBlock));
            }
        }
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)new File(this.plugin.getDataFolder(), "messages.yml"));
        this.loadConfigs();
    }
}

