/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Anti;

import dev.atrox.lightchat.LightChat;
import java.io.File;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class AntiSwear
implements Listener {
    private final LightChat plugin;
    private boolean enabled;
    private Set<String> swearWords;
    private String warningMessage;
    private boolean opBypass;
    private File configFile;
    private final Pattern wordSplitPattern = Pattern.compile("[\\s\\p{Punct}]+");
    private Set<UUID> warnedPlayers = new HashSet<UUID>();
    private String webhookUrl;
    private boolean webhookEnabled;
    private String embedTitle;
    private String embedColor;
    private List<EmbedField> embedFields;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    private File messagesFile;

    public AntiSwear(LightChat plugin) {
        this.plugin = plugin;
        this.loadConfig();
        this.loadMessages();
    }

    public void loadConfig() {
        this.configFile = new File(this.plugin.getDataFolder(), "antiswear.yml");
        if (!this.configFile.exists()) {
            this.plugin.saveResource("antiswear.yml", false);
        }
        this.reloadConfig();
    }

    public void loadMessages() {
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.reloadMessages();
    }

    public void reloadConfig() {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.enabled = config.getBoolean("enabled", true);
        this.swearWords = new HashSet<String>(config.getStringList("swear_words"));
        this.opBypass = config.getBoolean("op-bypass", true);
        this.webhookUrl = config.getString("webhook.url");
        this.webhookEnabled = config.getBoolean("webhook.enabled", false);
        this.embedTitle = config.getString("webhook.embed_title", "Swear Word Detected");
        this.embedColor = this.validateHexColor(config.getString("webhook.embed_color", "FF0000"));
        this.embedFields = new ArrayList<EmbedField>();
        for (String field : config.getStringList("webhook.embed_fields")) {
            if (field == null || field.trim().isEmpty()) continue;
            String[] parts = field.split(",", 2);
            this.embedFields.add(new EmbedField(parts[0].trim(), parts.length > 1 ? parts[1].trim() : ""));
        }
    }

    public void reloadMessages() {
        YamlConfiguration messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        this.warningMessage = this.plugin.getPrefixManager().formatMessage("antiswear.warning_message");
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (!this.enabled) {
            return;
        }
        Player player = event.getPlayer();
        if (this.opBypass && player.isOp()) {
            return;
        }
        if (this.warnedPlayers.contains(player.getUniqueId())) {
            return;
        }
        String message = event.getMessage();
        if (this.containsSwearWord(message)) {
            event.setCancelled(true);
            player.sendMessage(this.warningMessage);
            this.warnedPlayers.add(player.getUniqueId());
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.warnedPlayers.remove(player.getUniqueId()), 20L);
            if (this.webhookEnabled && this.webhookUrl != null) {
                this.sendWebhook(player, message);
            }
        }
    }

    public boolean containsSwearWord(String text) {
        String[] words;
        String normalized = this.normalizeText(text.replaceAll("[^\\p{L}\\p{N}]", ""));
        for (String swear : this.swearWords) {
            if (!normalized.contains(swear.toLowerCase())) continue;
            return true;
        }
        for (String word : words = this.wordSplitPattern.split(text)) {
            String normalizedWord = this.normalizeText(word);
            if (!this.swearWords.contains(normalizedWord)) continue;
            return true;
        }
        return false;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    private String normalizeText(String text) {
        return text.toLowerCase().replace("1", "i").replace("!", "i").replace("@", "a").replace("4", "a").replace("0", "o").replace("3", "e").replace("\u20ac", "e").replace("$", "s").replace("5", "s").replace("7", "t").replace("+", "t");
    }

    private void sendWebhook(Player player, String message) {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(this.webhookUrl).openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "application/json");
            try (OutputStream os = conn.getOutputStream();){
                os.write(this.buildWebhookPayload(player, message).getBytes(StandardCharsets.UTF_8));
            }
            conn.getResponseCode();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to send webhook: " + e.getMessage());
        }
    }

    private String buildWebhookPayload(Player player, String message) {
        StringBuilder json = new StringBuilder();
        json.append("{\"embeds\":[{\"title\":\"").append(this.embedTitle).append("\",\"color\":").append(Integer.parseInt(this.embedColor, 16)).append(",\"fields\":[");
        for (EmbedField field : this.embedFields) {
            json.append("{\"name\":\"").append(field.name).append("\",\"value\":\"").append(field.value.replace("{player}", player.getName()).replace("{message}", message).replace("{date}", this.dateFormat.format(new Date()))).append("\",\"inline\":true},");
        }
        if (!this.embedFields.isEmpty()) {
            json.deleteCharAt(json.length() - 1);
        }
        json.append("]}]}");
        return json.toString();
    }

    private String validateHexColor(String color) {
        return color != null && color.matches("^[0-9A-Fa-f]{6}$") ? color : "FF0000";
    }

    private static class EmbedField {
        final String name;
        final String value;

        EmbedField(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

