/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Chat;

import dev.atrox.lightchat.HexColor;
import dev.atrox.lightchat.LightChat;
import java.io.File;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class ChatClear
implements CommandExecutor {
    private static final int MAX_MESSAGES = 100;
    private final LightChat plugin;
    private FileConfiguration messages;

    public ChatClear(LightChat plugin) {
        this.plugin = plugin;
        this.reloadMessages();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("lightchat.chatclear")) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("no-permission"));
            return true;
        }
        this.clearChatForAllPlayers();
        String clearMessage = HexColor.translateAlternateColorCodes('&', this.plugin.getPrefixManager().applyPrefix(this.messages.getString("chatclear-message", "%prefix% &eChat has been cleared by &6%player%")));
        if (sender instanceof Player) {
            Player player = (Player)sender;
            clearMessage = clearMessage.replace("%player%", player.getName());
        } else {
            clearMessage = clearMessage.replace("%player%", "Console");
        }
        Bukkit.broadcastMessage((String)clearMessage);
        return true;
    }

    private void clearChatForAllPlayers() {
        Collection players = Bukkit.getServer().getOnlinePlayers();
        for (Player player : players) {
            for (int i = 0; i < 100; ++i) {
                player.sendMessage("");
            }
        }
    }

    private void reloadMessages() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
    }
}

