/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Chat;

import dev.atrox.lightchat.HexColor;
import dev.atrox.lightchat.LightChat;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class ChatDisable
implements CommandExecutor,
Listener {
    private final LightChat plugin;

    public ChatDisable(LightChat plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("lightchat.chatdisable")) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("no-permission"));
            return true;
        }
        FileConfiguration data = this.plugin.getDataConfig();
        data.set("chat.enabled", (Object)false);
        data.set("chat.disabled_by", (Object)sender.getName());
        this.plugin.saveDataFile();
        String msg = this.plugin.getPrefixManager().formatMessage("chatdisable-message");
        if (msg == null) {
            msg = "";
        }
        msg = msg.replace("%player%", sender.getName());
        this.plugin.getServer().broadcastMessage(HexColor.translateAlternateColorCodes('&', msg));
        return true;
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        Player player;
        if (!this.plugin.getDataConfig().getBoolean("chat.enabled", true) && !(player = event.getPlayer()).hasPermission("lightchat.bypass.chatdisable")) {
            event.setCancelled(true);
            String disabledBy = this.plugin.getDataConfig().getString("chat.disabled_by", "Unknown");
            String msg = this.plugin.getPrefixManager().formatMessage("chatdisable-blocked");
            if (msg == null) {
                msg = "";
            }
            msg = msg.replace("%player%", disabledBy);
            player.sendMessage(HexColor.translateAlternateColorCodes('&', msg));
        }
    }
}

