/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Chat;

import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.ItemStack;

public class ChatInventory
implements Listener {
    private final String inventoryPlaceholder;

    public ChatInventory(FileConfiguration config) {
        this.inventoryPlaceholder = config.getString("placeholders.inventory", "[inventory]");
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        String message = event.getMessage();
        if (message.contains(this.inventoryPlaceholder)) {
            ItemStack[] items = player.getInventory().getContents();
            StringBuilder inventoryString = new StringBuilder();
            for (ItemStack item : items) {
                if (item == null) continue;
                inventoryString.append(item.getType().toString()).append(" (x").append(item.getAmount()).append("), ");
            }
            if (inventoryString.length() > 2) {
                inventoryString.setLength(inventoryString.length() - 2);
            }
            TextComponent inventoryComponent = new TextComponent("Inventory");
            BaseComponent[] hoverComponents = new BaseComponent[]{new TextComponent(inventoryString.toString())};
            inventoryComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, hoverComponents));
            String[] splitMessage = message.split(this.inventoryPlaceholder);
            TextComponent finalMessage = new TextComponent("");
            for (int i = 0; i < splitMessage.length; ++i) {
                finalMessage.addExtra((BaseComponent)new TextComponent(splitMessage[i]));
                if (i >= splitMessage.length - 1) continue;
                finalMessage.addExtra((BaseComponent)inventoryComponent);
            }
            for (Player onlinePlayer : event.getRecipients()) {
                onlinePlayer.spigot().sendMessage((BaseComponent)finalMessage);
            }
            event.setCancelled(true);
        }
    }
}

