/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Chat;

import dev.atrox.lightchat.HexColor;
import dev.atrox.lightchat.LightChat;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class ColorfulChat
implements Listener {
    private final LightChat plugin;
    private boolean hexColorsEnabled;
    private boolean traditionalColorsEnabled;

    public ColorfulChat(LightChat plugin) {
        this.plugin = plugin;
        this.loadConfig();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private void loadConfig() {
        this.plugin.saveResource("config.yml", false);
        this.hexColorsEnabled = this.plugin.getConfig().getBoolean("hex-colors-enabled", true);
        this.traditionalColorsEnabled = this.plugin.getConfig().getBoolean("traditional-colors-enabled", true);
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        String message;
        Player player = event.getPlayer();
        String processedMessage = message = event.getMessage();
        if (this.traditionalColorsEnabled && player.hasPermission("lightchat.color.traditional")) {
            processedMessage = HexColor.translateAlternateColorCodes('&', processedMessage);
        }
        if (this.hexColorsEnabled && player.hasPermission("lightchat.color.hex")) {
            processedMessage = HexColor.translateAlternateColorCodes('&', processedMessage);
        }
        event.setMessage(processedMessage);
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.loadConfig();
    }
}

