/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Chat;

import dev.atrox.lightchat.HexColor;
import dev.atrox.lightchat.LightChat;
import org.bukkit.configuration.file.FileConfiguration;

public class PrefixManager {
    private final LightChat plugin;
    private String prefix;

    public PrefixManager(LightChat plugin) {
        this.plugin = plugin;
        this.reload();
    }

    public void reload() {
        FileConfiguration config = this.plugin.getConfig();
        this.prefix = HexColor.translateAlternateColorCodes('&', config.getString("prefix", "&b\u029f\u026a\u0262\u029c\u1d1b\u1d04\u029c\u1d00\u1d1b\u279c "));
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String applyPrefix(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        return message.replace("%prefix%", this.prefix);
    }

    public String formatMessage(String path) {
        FileConfiguration messages = this.plugin.getCustomConfig("messages.yml");
        String message = messages.getString(path, "");
        return HexColor.translateAlternateColorCodes('&', this.applyPrefix(message));
    }
}

