/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Chat;

import dev.atrox.lightchat.LightChat;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class ProximityChat
implements Listener {
    private final LightChat plugin;
    private boolean enabled;
    private boolean blockMessage;
    private boolean sendWarning;
    private int checkRadius;
    private boolean opBypass;
    private String warningMessage;
    private final Set<UUID> notifiedPlayers = new HashSet<UUID>();
    private long lastCleanup = 0L;
    private static final long CLEANUP_INTERVAL = 30000L;

    public ProximityChat(LightChat plugin) {
        this.plugin = plugin;
        this.loadConfig();
        this.loadMessages();
    }

    public void loadConfig() {
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.plugin.saveResource("config.yml", false);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        this.enabled = config.getBoolean("proximity-chat.enabled", false);
        this.blockMessage = config.getBoolean("proximity-chat.block-message", false);
        this.sendWarning = config.getBoolean("proximity-chat.warning", true);
        this.checkRadius = config.getInt("proximity-chat.check-radius", 50);
        this.opBypass = config.getBoolean("proximity-chat.op-bypass", true);
    }

    public void loadMessages() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        YamlConfiguration messages = YamlConfiguration.loadConfiguration((File)messagesFile);
        this.warningMessage = this.plugin.getPrefixManager().formatMessage("proximity-chat-warning-message");
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (!this.enabled) {
            return;
        }
        Player player = event.getPlayer();
        if (this.opBypass && player.isOp()) {
            return;
        }
        if (!player.isOp() && player.hasPermission("lightchat.proximitychat.bypass")) {
            return;
        }
        boolean hasNearbyPlayers = this.hasNearbyPlayers(player);
        if (!hasNearbyPlayers) {
            if (this.blockMessage) {
                event.setCancelled(true);
            }
            if (this.sendWarning && !this.notifiedPlayers.contains(player.getUniqueId())) {
                String formattedMessage = this.warningMessage.replace("%radius%", String.valueOf(this.checkRadius));
                player.sendMessage(formattedMessage);
                this.notifiedPlayers.add(player.getUniqueId());
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.notifiedPlayers.remove(player.getUniqueId()), 100L);
            }
        }
    }

    private boolean hasNearbyPlayers(Player player) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCleanup > 30000L) {
            this.notifiedPlayers.clear();
            this.lastCleanup = currentTime;
        }
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (onlinePlayer.equals(player) || !onlinePlayer.getWorld().equals(player.getWorld()) || !(onlinePlayer.getLocation().distanceSquared(player.getLocation()) <= (double)(this.checkRadius * this.checkRadius))) continue;
            return true;
        }
        return false;
    }

    public void reload() {
        this.loadConfig();
        this.loadMessages();
        this.notifiedPlayers.clear();
    }
}

