/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Chat;

import dev.atrox.lightchat.Chat.HexColor;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class WelcomeListener
implements Listener {
    private final JavaPlugin plugin;
    private FileConfiguration messagesConfig;
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private final Map<String, String> headCache;
    private final ExecutorService asyncExecutor;
    private final ScheduledExecutorService cleanupExecutor;
    private static final int MAX_CACHE_SIZE = 500;
    private static final int CACHE_CLEANUP_MINUTES = 120;

    public WelcomeListener(JavaPlugin plugin) {
        this.plugin = plugin;
        this.headCache = new ConcurrentHashMap<String, String>();
        this.asyncExecutor = Executors.newFixedThreadPool(2, r -> {
            Thread t = new Thread(r, "LightChat-AsyncProcessor-" + plugin.getName());
            t.setPriority(1);
            return t;
        });
        this.cleanupExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "LightChat-CacheCleaner-" + plugin.getName());
            t.setPriority(1);
            return t;
        });
        this.loadMessagesConfig();
        this.startCacheCleanup();
    }

    private void loadMessagesConfig() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
    }

    private void startCacheCleanup() {
        this.cleanupExecutor.scheduleAtFixedRate(() -> {
            if (this.headCache.size() > 500) {
                Iterator<String> iterator = this.headCache.keySet().iterator();
                while (iterator.hasNext() && this.headCache.size() > 500) {
                    iterator.next();
                    iterator.remove();
                }
            }
        }, 120L, 120L, TimeUnit.MINUTES);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.plugin.getConfig().getBoolean("welcome-message-enabled", true)) {
            return;
        }
        Player player = event.getPlayer();
        int onlineCount = this.plugin.getServer().getOnlinePlayers().size();
        this.asyncExecutor.execute(() -> {
            try {
                String head = this.getHead(player.getName());
                String message = this.formatMessage(player, onlineCount);
                List<String> finalMessage = this.mergeMessages(head, message);
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.sendWelcomeMessage(player, finalMessage));
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Welcome message error for " + player.getName(), e);
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> player.sendMessage(ChatColor.YELLOW + "Welcome to the server!"));
            }
        });
    }

    private String getHead(String playerName) {
        return this.headCache.computeIfAbsent(playerName, this::createHead);
    }

    private void sendWelcomeMessage(Player player, List<String> finalMessage) {
        for (String line : finalMessage) {
            if (line.contains("%discord%")) {
                this.handleDiscordLink(player, line);
                continue;
            }
            if (line.contains("%website%")) {
                this.handleWebsiteLink(player, line);
                continue;
            }
            player.sendMessage(HexColor.translateAlternateColorCodes('&', line));
        }
    }

    private void handleDiscordLink(Player player, String line) {
        BaseComponent[] components;
        String discordLink = this.messagesConfig.getString("welcome-message.discord-link");
        if (discordLink == null) {
            return;
        }
        String fullDiscordUrl = discordLink.startsWith("http") ? discordLink : "https://" + discordLink;
        String replaced = line.replace("%discord%", discordLink);
        String colored = HexColor.translateAlternateColorCodes('&', replaced);
        for (BaseComponent comp : components = TextComponent.fromLegacyText((String)colored)) {
            comp.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, fullDiscordUrl));
            String hoverText = HexColor.translateAlternateColorCodes('&', this.messagesConfig.getString("welcome-message.click-hover-text"));
            comp.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)hoverText)));
        }
        player.spigot().sendMessage(components);
    }

    private void handleWebsiteLink(Player player, String line) {
        BaseComponent[] components;
        String websiteLink = this.messagesConfig.getString("welcome-message.website-link");
        if (websiteLink == null) {
            return;
        }
        String fullWebsiteUrl = websiteLink.startsWith("http") ? websiteLink : "https://" + websiteLink;
        String replaced = line.replace("%website%", websiteLink);
        String colored = HexColor.translateAlternateColorCodes('&', replaced);
        for (BaseComponent comp : components = TextComponent.fromLegacyText((String)colored)) {
            comp.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, fullWebsiteUrl));
            String hoverText = HexColor.translateAlternateColorCodes('&', this.messagesConfig.getString("welcome-message.click-hover-text"));
            comp.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)hoverText)));
        }
        player.spigot().sendMessage(components);
    }

    private List<String> mergeMessages(String head, String message) {
        if (head == null || head.isEmpty()) {
            return Arrays.asList(message.split("\n"));
        }
        String[] headLines = head.split("\n");
        String[] messageLines = message.split("\n");
        ArrayList<String> merged = new ArrayList<String>(Math.max(headLines.length, messageLines.length));
        int maxLines = Math.max(headLines.length, messageLines.length);
        for (int i = 0; i < maxLines; ++i) {
            StringBuilder line = new StringBuilder(64);
            if (i < headLines.length) {
                line.append(headLines[i]);
            }
            if (i < messageLines.length) {
                if (line.length() > 0) {
                    line.append("  ");
                }
                line.append(messageLines[i]);
            }
            merged.add(line.toString());
        }
        return merged;
    }

    private String formatMessage(Player player, int onlineCount) {
        String raw = this.messagesConfig.getString("welcome-message.message");
        if (raw == null) {
            return "";
        }
        return raw.replace("%online%", String.valueOf(onlineCount)).replace("%date%", DATE_FORMATTER.format(LocalDate.now())).replace("%player%", player.getName()).replace("%servername%", this.messagesConfig.getString("servername", this.plugin.getServer().getName())).replace("%discord%", "%discord%").replace("%website%", "%website%");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createHead(String playerName) {
        String urlString = "https://minotar.net/avatar/" + playerName + "/8.png";
        HttpURLConnection connection = null;
        try {
            String string;
            block18: {
                BufferedImage skin;
                InputStream inputStream;
                block16: {
                    String string2;
                    block17: {
                        URL url = new URL(urlString);
                        connection = (HttpURLConnection)url.openConnection();
                        connection.setConnectTimeout(2000);
                        connection.setReadTimeout(2000);
                        connection.setRequestProperty("User-Agent", "LightChat/3.2");
                        inputStream = connection.getInputStream();
                        skin = ImageIO.read(inputStream);
                        if (skin != null && skin.getWidth() >= 8 && skin.getHeight() >= 8) break block16;
                        string2 = "";
                        if (inputStream == null) break block17;
                        inputStream.close();
                    }
                    return string2;
                }
                try {
                    StringBuilder head = new StringBuilder(512);
                    for (int y = 0; y < 8; ++y) {
                        for (int x = 0; x < 8; ++x) {
                            int rgb = skin.getRGB(x, y);
                            String hexColor = String.format("#%06X", rgb & 0xFFFFFF);
                            head.append(hexColor).append("\u2588");
                        }
                        if (y >= 7) continue;
                        head.append("\n");
                    }
                    string = head.toString();
                    if (inputStream == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        String string3 = "";
                        return string3;
                    }
                }
                inputStream.close();
            }
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public void shutdown() {
        this.asyncExecutor.shutdown();
        this.cleanupExecutor.shutdown();
        try {
            if (!this.asyncExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.asyncExecutor.shutdownNow();
            }
            if (!this.cleanupExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.cleanupExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.asyncExecutor.shutdownNow();
            this.cleanupExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.headCache.clear();
    }
}

