/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Commands;

import dev.atrox.lightchat.HexColor;
import dev.atrox.lightchat.LightChat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class CountdownCommand
implements CommandExecutor,
TabCompleter {
    private final LightChat plugin;
    private final List<String> displayModes = Arrays.asList("title", "subtitle", "actionbar");
    private final Map<CommandSender, BukkitTask> activeCountdowns = new HashMap<CommandSender, BukkitTask>();

    public CountdownCommand(LightChat plugin) {
        this.plugin = plugin;
        plugin.getCommand("countdown").setExecutor((CommandExecutor)this);
        plugin.getCommand("countdown").setTabCompleter((TabCompleter)this);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int seconds;
        if (!sender.hasPermission("lightchat.countdown")) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("no-permission"));
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("countdown.usage-message"));
            return true;
        }
        if (args[0].equalsIgnoreCase("stop")) {
            this.stopCountdown(sender);
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("countdown.usage-message"));
            return true;
        }
        String displayMode = args[0].toLowerCase();
        if (!this.displayModes.contains(displayMode)) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("countdown.invalid-mode-message"));
            return true;
        }
        try {
            seconds = Integer.parseInt(args[1]);
            if (seconds <= 0) {
                sender.sendMessage(this.plugin.getPrefixManager().formatMessage("countdown.invalid-seconds-message"));
                return true;
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("countdown.invalid-number-message"));
            return true;
        }
        this.startCountdown(sender, displayMode, seconds);
        return true;
    }

    private void startCountdown(final CommandSender sender, final String displayMode, final int seconds) {
        if (this.activeCountdowns.containsKey(sender)) {
            this.activeCountdowns.get(sender).cancel();
        }
        String soundName = this.plugin.getConfig().getString("countdown.tick-sound", "BLOCK_NOTE_BLOCK_PLING");
        final Sound sound = this.getSoundFromConfig(soundName, Sound.BLOCK_NOTE_BLOCK_PLING);
        sender.sendMessage(this.plugin.getPrefixManager().formatMessage("countdown.started-message"));
        BukkitTask task = new BukkitRunnable(){
            int timeLeft;
            {
                this.timeLeft = seconds;
            }

            public void run() {
                if (this.timeLeft <= 0) {
                    CountdownCommand.this.broadcastFinish();
                    CountdownCommand.this.activeCountdowns.remove(sender);
                    this.cancel();
                    return;
                }
                String message = String.valueOf(this.timeLeft);
                switch (displayMode) {
                    case "title": {
                        CountdownCommand.this.broadcastTitle(message, "");
                        break;
                    }
                    case "subtitle": {
                        CountdownCommand.this.broadcastTitle("", message);
                        break;
                    }
                    case "actionbar": {
                        CountdownCommand.this.broadcastActionBar(message);
                    }
                }
                CountdownCommand.this.playSound(sound);
                --this.timeLeft;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        this.activeCountdowns.put(sender, task);
    }

    private void stopCountdown(CommandSender sender) {
        BukkitTask task = this.activeCountdowns.get(sender);
        if (task != null) {
            task.cancel();
            this.activeCountdowns.remove(sender);
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("countdown.stopped-message"));
        } else {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("countdown.no-countdown-message"));
        }
    }

    private Sound getSoundFromConfig(String soundName, Sound defaultSound) {
        try {
            return Sound.valueOf((String)soundName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid sound in config: " + soundName + ". Using default sound.");
            return defaultSound;
        }
    }

    private void broadcastTitle(String title, String subtitle) {
        String formattedTitle = HexColor.translateAlternateColorCodes('&', title);
        String formattedSubtitle = HexColor.translateAlternateColorCodes('&', subtitle);
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendTitle(formattedTitle, formattedSubtitle, 5, 20, 5);
        }
    }

    private void broadcastActionBar(String message) {
        String formattedMessage = HexColor.translateAlternateColorCodes('&', message);
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)formattedMessage));
        }
    }

    private void playSound(Sound sound) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
        }
    }

    private void broadcastFinish() {
        String finishSoundName = this.plugin.getConfig().getString("countdown.finish-sound", "ENTITY_PLAYER_LEVELUP");
        Sound finishSound = this.getSoundFromConfig(finishSoundName, Sound.ENTITY_PLAYER_LEVELUP);
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.playSound(player.getLocation(), finishSound, 1.0f, 1.0f);
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            ArrayList<String> modes = new ArrayList<String>(this.displayModes);
            modes.add("stop");
            completions.addAll(modes.stream().filter(mode -> mode.startsWith(args[0].toLowerCase())).collect(Collectors.toList()));
        } else if (args.length == 2 && !args[0].equalsIgnoreCase("stop")) {
            completions.add("<seconds>");
        }
        return completions;
    }
}

