/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Commands;

import dev.atrox.lightchat.HexColor;
import dev.atrox.lightchat.LightChat;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class DiscordCommand
implements CommandExecutor {
    private final LightChat plugin;

    public DiscordCommand(LightChat plugin) {
        this.plugin = plugin;
        plugin.getCommand("discord").setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        FileConfiguration messagesConfig = this.plugin.getCustomConfig("messages.yml");
        String discordLink = messagesConfig.getString("discord-command.discord-link", "https://discord.gg/your-discord-link");
        String discordMessage = messagesConfig.getString("discord-command.message", "&bJoin our Discord server:\n&e%discord-link%");
        String hoverText = HexColor.translateAlternateColorCodes('&', messagesConfig.getString("discord-command.discord-hover", "&eClick to join our Discord server!"));
        if (sender instanceof Player) {
            Player player = (Player)sender;
            TextComponent link = new TextComponent(HexColor.translateAlternateColorCodes('&', discordLink));
            link.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, discordLink));
            link.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)hoverText)));
            TextComponent message = new TextComponent(HexColor.translateAlternateColorCodes('&', discordMessage.split("%discord-link%")[0]));
            message.addExtra((BaseComponent)link);
            player.spigot().sendMessage((BaseComponent)message);
        } else {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', discordMessage.replace("%discord-link%", discordLink)));
        }
        return true;
    }
}

