/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Commands;

import dev.atrox.lightchat.HexColor;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class DoNotDisturb
implements CommandExecutor {
    private final JavaPlugin plugin;
    private static final Set<Player> doNotDisturbPlayers = new HashSet<Player>();

    public DoNotDisturb(JavaPlugin plugin) {
        this.plugin = plugin;
        plugin.getCommand("dnd").setExecutor((CommandExecutor)this);
    }

    public static boolean isInDoNotDisturb(Player player) {
        return doNotDisturbPlayers.contains(player);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', "&cOnly players can use this command!"));
            return true;
        }
        Player player = (Player)sender;
        FileConfiguration config = this.plugin.getConfig();
        if (doNotDisturbPlayers.contains(player)) {
            doNotDisturbPlayers.remove(player);
            if (config.getBoolean("dnd_modes.sound", false)) {
                this.playSound(player, config.getString("dnd_modes.toggle_sound", "ENTITY_EXPERIENCE_ORB_PICKUP"));
            }
            player.sendMessage(HexColor.translateAlternateColorCodes('&', config.getString("dnd_modes.dnd_mode_off", "&aDo Not Disturb mode is now off. You will receive notifications.")));
        } else {
            doNotDisturbPlayers.add(player);
            if (config.getBoolean("dnd_modes.sound", false)) {
                this.playSound(player, config.getString("dnd_modes.toggle_sound", "ENTITY_EXPERIENCE_ORB_PICKUP"));
            }
            player.sendMessage(HexColor.translateAlternateColorCodes('&', config.getString("dnd_modes.dnd_mode_on", "&cDo Not Disturb mode is now on. You will not receive notifications.")));
        }
        return true;
    }

    private void playSound(Player player, String soundName) {
        try {
            Sound sound = Sound.valueOf((String)soundName);
            player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid DND toggle sound setting: " + soundName);
        }
    }
}

