/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Commands;

import dev.atrox.lightchat.Anti.AntiAdvertising;
import dev.atrox.lightchat.Anti.AntiSwear;
import dev.atrox.lightchat.Commands.DoNotDisturb;
import dev.atrox.lightchat.Commands.ReplyCommand;
import dev.atrox.lightchat.HexColor;
import java.io.File;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class MsgCommand
implements CommandExecutor {
    private final JavaPlugin plugin;
    private final AntiSwear antiSwear;
    private final AntiAdvertising antiAdvertising;
    private FileConfiguration messages;

    public MsgCommand(JavaPlugin plugin, AntiSwear antiSwear, AntiAdvertising antiAdvertising) {
        this.plugin = plugin;
        this.antiSwear = antiSwear;
        this.antiAdvertising = antiAdvertising;
        plugin.getCommand("msg").setExecutor((CommandExecutor)this);
        this.reloadMessages();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', this.messages.getString("player-only", "")));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', this.messages.getString("msg-usage", "")));
            return true;
        }
        Player playerSender = (Player)sender;
        Player recipient = this.plugin.getServer().getPlayer(args[0]);
        if (recipient == null || !recipient.isOnline()) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', this.messages.getString("player-not-found", "")));
            return true;
        }
        if (DoNotDisturb.isInDoNotDisturb(recipient)) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', this.messages.getString("dnd-mode-msg", "")));
            return true;
        }
        StringBuilder messageBuilder = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            if (i > 1) {
                messageBuilder.append(" ");
            }
            messageBuilder.append(args[i]);
        }
        String message = messageBuilder.toString();
        FileConfiguration config = this.plugin.getConfig();
        if (this.antiSwear.containsSwearWord(message)) {
            playerSender.sendMessage(HexColor.translateAlternateColorCodes('&', this.antiSwear.getWarningMessage()));
            return true;
        }
        if (config.getBoolean("msg_protection.antiadvertising", true) && this.antiAdvertising.containsProhibitedContent(message)) {
            playerSender.sendMessage(HexColor.translateAlternateColorCodes('&', this.antiAdvertising.getWarningMessage()));
            return true;
        }
        message = HexColor.translateAlternateColorCodes('&', message);
        String sentFormat = HexColor.translateAlternateColorCodes('&', config.getString("msg_format.sent", "&7[&aYou \u2192 %recipient%&7] &f%message%"));
        String receivedFormat = HexColor.translateAlternateColorCodes('&', config.getString("msg_format.received", "&7[&a%sender% \u2192 You&7] &f%message%"));
        String notificationSound = config.getString("msg_notification.sound", "ENTITY_EXPERIENCE_ORB_PICKUP").toUpperCase();
        String senderName = playerSender.getDisplayName();
        String recipientName = recipient.getDisplayName();
        String formattedSentMessage = sentFormat.replace("%sender%", senderName).replace("%recipient%", recipientName).replace("%message%", message);
        String formattedReceivedMessage = receivedFormat.replace("%sender%", senderName).replace("%message%", message);
        playerSender.sendMessage(formattedSentMessage);
        recipient.sendMessage(formattedReceivedMessage);
        ReplyCommand.setLastMessageSender(recipient, playerSender);
        try {
            Sound sound = Sound.valueOf((String)notificationSound);
            recipient.playSound(recipient.getLocation(), sound, 1.0f, 1.0f);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid notification sound setting: " + notificationSound);
        }
        return true;
    }

    private void reloadMessages() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
    }
}

