/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Commands;

import dev.atrox.lightchat.HexColor;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandMap;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ServerInvalidCommandHandler
implements Listener {
    private final WeakReference<JavaPlugin> pluginRef;
    private volatile String unknownCommandMessage;
    private volatile CommandMap commandMap;

    public ServerInvalidCommandHandler(JavaPlugin plugin) {
        this.pluginRef = new WeakReference<JavaPlugin>(plugin);
        this.loadMessages();
        this.getCommandMap();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private void loadMessages() {
        JavaPlugin plugin = (JavaPlugin)this.pluginRef.get();
        if (plugin == null) {
            return;
        }
        File messagesFile = new File(plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            plugin.saveResource("messages.yml", false);
        }
        YamlConfiguration messages = YamlConfiguration.loadConfiguration((File)messagesFile);
        this.unknownCommandMessage = HexColor.translateAlternateColorCodes('&', messages.getString("server-unknown-command"));
    }

    private void getCommandMap() {
        block2: {
            try {
                Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
                commandMapField.setAccessible(true);
                this.commandMap = (CommandMap)commandMapField.get(Bukkit.getServer());
            }
            catch (Exception e) {
                JavaPlugin plugin = (JavaPlugin)this.pluginRef.get();
                if (plugin == null) break block2;
                plugin.getLogger().warning("Failed to get command map");
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        String[] parts = event.getMessage().split(" ", 2);
        String command = parts[0].substring(1);
        if (this.commandMap != null && this.commandMap.getCommand(command) == null) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(this.unknownCommandMessage);
        }
    }

    public void reload() {
        this.loadMessages();
    }

    public void destroy() {
        HandlerList.unregisterAll((Listener)this);
    }
}

