/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Commands;

import dev.atrox.lightchat.HexColor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class TitleCommand
implements CommandExecutor,
TabCompleter {
    private final JavaPlugin plugin;
    private FileConfiguration messages;

    public TitleCommand(JavaPlugin plugin) {
        this.plugin = plugin;
        plugin.getCommand("title").setExecutor((CommandExecutor)this);
        plugin.getCommand("title").setTabCompleter((TabCompleter)this);
        this.reloadMessages();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("lightchat.title")) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', this.messages.getString("no-permission")));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', this.messages.getString("title-usage")));
            return false;
        }
        String target = args[0];
        StringBuilder titleBuilder = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            titleBuilder.append(args[i]).append(" ");
        }
        String title = HexColor.translateAlternateColorCodes('&', titleBuilder.toString().trim());
        if (target.equalsIgnoreCase("all")) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.sendTitle(player, title);
            }
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', this.messages.getString("title-sent-to-all")));
        } else {
            Player player = Bukkit.getPlayer((String)target);
            if (player != null) {
                this.sendTitle(player, title);
                sender.sendMessage(HexColor.translateAlternateColorCodes('&', this.messages.getString("title-sent-to-player").replace("%player%", player.getName())));
            } else {
                sender.sendMessage(HexColor.translateAlternateColorCodes('&', this.messages.getString("player-not-found")));
            }
        }
        return true;
    }

    private void sendTitle(Player player, String title) {
        player.sendTitle(title, "", 10, 70, 20);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.add("all");
            for (Player player : Bukkit.getOnlinePlayers()) {
                completions.add(player.getName());
            }
        }
        return completions;
    }

    private void reloadMessages() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
    }
}

