/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat;

import dev.atrox.lightchat.Anti.AntiAdvertising;
import dev.atrox.lightchat.Anti.AntiCaps;
import dev.atrox.lightchat.Anti.AntiColorCode;
import dev.atrox.lightchat.Anti.AntiLongRepeatedChars;
import dev.atrox.lightchat.Anti.AntiMessageRepeat;
import dev.atrox.lightchat.Anti.AntiSpaceSpam;
import dev.atrox.lightchat.Anti.AntiSpam;
import dev.atrox.lightchat.Anti.AntiSwear;
import dev.atrox.lightchat.Anti.AntiTabComplete;
import dev.atrox.lightchat.Anti.BlockCommand;
import dev.atrox.lightchat.Chat.AutoResponder;
import dev.atrox.lightchat.Chat.ChatClear;
import dev.atrox.lightchat.Chat.ChatDisable;
import dev.atrox.lightchat.Chat.ChatEnable;
import dev.atrox.lightchat.Chat.ColorfulChat;
import dev.atrox.lightchat.Chat.JoinQuitMessage;
import dev.atrox.lightchat.Chat.Mention;
import dev.atrox.lightchat.Chat.PlayerChatClear;
import dev.atrox.lightchat.Chat.PrefixManager;
import dev.atrox.lightchat.Chat.ProximityChat;
import dev.atrox.lightchat.Chat.ToggleChat;
import dev.atrox.lightchat.Chat.WelcomeListener;
import dev.atrox.lightchat.Commands.ActionBarCommand;
import dev.atrox.lightchat.Commands.AnnounceCommand;
import dev.atrox.lightchat.Commands.BroadCastCommand;
import dev.atrox.lightchat.Commands.CountdownCommand;
import dev.atrox.lightchat.Commands.DNDPlaceholderExpansion;
import dev.atrox.lightchat.Commands.DiscordCommand;
import dev.atrox.lightchat.Commands.DoNotDisturb;
import dev.atrox.lightchat.Commands.LiveCommand;
import dev.atrox.lightchat.Commands.MsgCommand;
import dev.atrox.lightchat.Commands.PingCommand;
import dev.atrox.lightchat.Commands.ReloadCommand;
import dev.atrox.lightchat.Commands.ReplyCommand;
import dev.atrox.lightchat.Commands.ServerInvalidCommandHandler;
import dev.atrox.lightchat.Commands.SubtitleCommand;
import dev.atrox.lightchat.Commands.TitleCommand;
import dev.atrox.lightchat.Commands.WebsiteCommand;
import dev.atrox.lightchat.HelpCommand;
import dev.atrox.lightchat.UpdateChecker.UpdateChecker;
import dev.atrox.lightchat.bstats.bukkit.Metrics;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class LightChat
extends JavaPlugin {
    private final Map<String, FileConfiguration> customConfigs = new HashMap<String, FileConfiguration>();
    private FileConfiguration dataConfig;
    private File dataFile;
    private AntiSwear antiSwear;
    private AntiSpam antiSpam;
    private AntiLongRepeatedChars antiLongRepeatedChars;
    private AntiAdvertising antiAdvertising;
    private AntiTabComplete antiTabComplete;
    private BlockCommand blockCommand;
    private AntiMessageRepeat antiMessageRepeat;
    private AntiColorCode antiColorCode;
    private AutoResponder autoResponder;
    private ColorfulChat colorfulChat;
    private UpdateChecker updateChecker;
    private AntiSpaceSpam antiSpaceSpam;
    private LiveCommand liveCommand;
    private PrefixManager prefixManager;
    private ProximityChat proximityChat;
    private ServerInvalidCommandHandler commandHandler;

    public void onEnable() {
        this.loadConfigFiles();
        this.loadDataFile();
        this.prefixManager = new PrefixManager(this);
        this.initializeFeatures();
        this.registerEvents();
        this.registerCommands();
        this.commandHandler = new ServerInvalidCommandHandler(this);
        new Metrics(this, 23591);
        this.updateChecker = new UpdateChecker(this, 116760);
        this.updateChecker.checkOnStartup();
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new DNDPlaceholderExpansion(this).register();
        }
    }

    public void onDisable() {
        if (this.commandHandler != null) {
            this.commandHandler.destroy();
            this.commandHandler = null;
        }
        HandlerList.unregisterAll((Plugin)this);
        this.customConfigs.clear();
        this.saveDataFile();
    }

    private void loadConfigFiles() {
        String[] configFiles;
        this.getConfig().options().copyDefaults(true);
        this.saveDefaultConfig();
        this.reloadConfig();
        for (String fileName : configFiles = new String[]{"messages.yml", "antiadvertising.yml", "antitabcomplete.yml", "blockcommand.yml", "autoresponder.yml", "antiswear.yml"}) {
            this.reloadCustomConfig(fileName);
        }
    }

    public void reloadCustomConfig(String fileName) {
        File file = new File(this.getDataFolder(), fileName);
        if (!file.exists()) {
            this.saveResource(fileName, false);
        }
        this.customConfigs.put(fileName, (FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
    }

    public FileConfiguration getCustomConfig(String fileName) {
        return this.customConfigs.getOrDefault(fileName, null);
    }

    public void loadDataFile() {
        this.dataFile = new File(this.getDataFolder(), "data.yml");
        if (!this.dataFile.exists()) {
            this.saveResource("data.yml", false);
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    public FileConfiguration getDataConfig() {
        if (this.dataConfig == null) {
            this.loadDataFile();
        }
        return this.dataConfig;
    }

    public void saveDataFile() {
        try {
            if (this.dataConfig != null) {
                this.dataConfig.save(this.dataFile);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public PrefixManager getPrefixManager() {
        return this.prefixManager;
    }

    private void initializeFeatures() {
        this.antiSwear = new AntiSwear(this);
        this.antiSpam = new AntiSpam(this);
        this.antiLongRepeatedChars = new AntiLongRepeatedChars(this);
        this.antiAdvertising = new AntiAdvertising(this);
        this.antiTabComplete = new AntiTabComplete(this);
        this.blockCommand = new BlockCommand(this);
        this.antiMessageRepeat = new AntiMessageRepeat(this);
        this.antiColorCode = new AntiColorCode(this);
        this.autoResponder = new AutoResponder(this);
        this.colorfulChat = new ColorfulChat(this);
        this.antiSpaceSpam = new AntiSpaceSpam(this);
        this.liveCommand = new LiveCommand(this);
        this.proximityChat = new ProximityChat(this);
    }

    private void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)this.antiSwear, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new JoinQuitMessage(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new AntiCaps(this.getConfig()), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.antiSpam, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.antiLongRepeatedChars, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.antiAdvertising, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new Mention(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.antiTabComplete, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.blockCommand, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.antiMessageRepeat, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.antiColorCode, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.antiSpaceSpam, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WelcomeListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.proximityChat, (Plugin)this);
    }

    private void registerCommands() {
        this.getCommand("chatclear").setExecutor((CommandExecutor)new ChatClear(this));
        this.getCommand("chatdisable").setExecutor((CommandExecutor)new ChatDisable(this));
        this.getCommand("chatenable").setExecutor((CommandExecutor)new ChatEnable(this));
        this.getCommand("lightchatreload").setExecutor((CommandExecutor)new ReloadCommand(this));
        this.getCommand("lightchathelp").setExecutor((CommandExecutor)new HelpCommand());
        this.getCommand("msg").setExecutor((CommandExecutor)new MsgCommand(this, this.antiSwear, this.antiAdvertising));
        this.getCommand("website").setExecutor((CommandExecutor)new WebsiteCommand(this));
        this.getCommand("discord").setExecutor((CommandExecutor)new DiscordCommand(this));
        this.getCommand("ping").setExecutor((CommandExecutor)new PingCommand(this));
        this.getCommand("title").setExecutor((CommandExecutor)new TitleCommand(this));
        this.getCommand("actionbar").setExecutor((CommandExecutor)new ActionBarCommand(this));
        this.getCommand("broadcast").setExecutor((CommandExecutor)new BroadCastCommand(this));
        this.getCommand("announce").setExecutor((CommandExecutor)new AnnounceCommand(this));
        this.getCommand("dnd").setExecutor((CommandExecutor)new DoNotDisturb(this));
        this.getCommand("togglechat").setExecutor((CommandExecutor)new ToggleChat(this));
        this.getCommand("reply").setExecutor((CommandExecutor)new ReplyCommand(this));
        this.getCommand("pchatclear").setExecutor((CommandExecutor)new PlayerChatClear(this));
        this.getCommand("subtitle").setExecutor((CommandExecutor)new SubtitleCommand(this));
        this.getCommand("live").setExecutor((CommandExecutor)this.liveCommand);
        this.getCommand("live").setTabCompleter((TabCompleter)this.liveCommand);
        CountdownCommand countdown = new CountdownCommand(this);
        this.getCommand("countdown").setExecutor((CommandExecutor)countdown);
        this.getCommand("countdown").setTabCompleter((TabCompleter)countdown);
    }
}

