/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Anti;

import dev.atrox.lightchat.LightChat;
import java.io.File;
import java.util.regex.Pattern;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class AntiColorCode
implements Listener {
    private final LightChat plugin;
    private boolean enabled;
    private boolean block;
    private boolean bypassOp;
    private String warningMessage;
    private static final Pattern COLOR_CODE_PATTERN = Pattern.compile("&[0-9a-fk-or]");
    private FileConfiguration messages;

    public AntiColorCode(LightChat plugin) {
        this.plugin = plugin;
        this.reloadConfig();
    }

    public void reloadConfig() {
        FileConfiguration config = this.plugin.getConfig();
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
        this.enabled = config.getBoolean("anti-color-code.enabled", true);
        this.block = config.getBoolean("anti-color-code.block", true);
        this.bypassOp = config.getBoolean("anti-color-code.bypass-op", true);
        this.warningMessage = this.plugin.getPrefixManager().formatMessage("anticolorcode-warning");
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (!this.enabled) {
            return;
        }
        Player player = event.getPlayer();
        String message = event.getMessage();
        if (this.bypassOp && player.isOp()) {
            return;
        }
        if (COLOR_CODE_PATTERN.matcher(message).find()) {
            if (this.block) {
                event.setCancelled(true);
                player.sendMessage(this.warningMessage);
            } else {
                event.setMessage(message.replaceAll("&[0-9a-fk-or]", ""));
            }
        }
    }
}

