/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Anti;

import dev.atrox.lightchat.LightChat;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class AntiMessageRepeat
implements Listener {
    private final LightChat plugin;
    private final Map<UUID, PlayerMessageData> playerData = new ConcurrentHashMap<UUID, PlayerMessageData>();
    private boolean enabled;
    private boolean opBypass;
    private int maxRepeats;
    private int cooldown;
    private FileConfiguration messagesConfig;

    public AntiMessageRepeat(LightChat plugin) {
        this.plugin = plugin;
        this.loadMessagesConfig();
        this.reloadConfig();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChat(AsyncPlayerChatEvent event) {
        if (!this.enabled || event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.isOp() && this.opBypass) {
            return;
        }
        String message = event.getMessage().trim();
        UUID playerId = player.getUniqueId();
        PlayerMessageData data = this.playerData.computeIfAbsent(playerId, k -> new PlayerMessageData());
        if (data.isInCooldownFor(message)) {
            player.sendMessage(this.plugin.getPrefixManager().formatMessage("anti-message-repeat-warning").replace("%message%", message).replace("%time%", String.valueOf(data.getRemainingCooldown())));
            event.setCancelled(true);
            return;
        }
        if (!message.equalsIgnoreCase(data.getLastMessage())) {
            data.resetCount();
            data.setLastMessage(message);
            return;
        }
        data.incrementCount();
        if (data.getCount() >= this.maxRepeats) {
            player.sendMessage(this.plugin.getPrefixManager().formatMessage("anti-message-repeat-warning").replace("%message%", message).replace("%time%", String.valueOf(this.cooldown)));
            data.startCooldown(message, this.cooldown);
            event.setCancelled(true);
        }
    }

    public void reloadConfig() {
        FileConfiguration config = this.plugin.getConfig();
        this.enabled = config.getBoolean("anti-message-repeat.enabled", true);
        this.opBypass = config.getBoolean("anti-message-repeat.op-bypass", false);
        this.maxRepeats = config.getInt("anti-message-repeat.max-repeats", 2);
        this.cooldown = config.getInt("anti-message-repeat.cooldown", 10);
    }

    private void loadMessagesConfig() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
    }

    private static class PlayerMessageData {
        private String lastMessage;
        private String cooldownMessage;
        private int count;
        private long cooldownEnd;

        private PlayerMessageData() {
        }

        public String getLastMessage() {
            return this.lastMessage;
        }

        public void setLastMessage(String message) {
            this.lastMessage = message;
        }

        public int getCount() {
            return this.count;
        }

        public void incrementCount() {
            ++this.count;
        }

        public void resetCount() {
            this.count = 0;
        }

        public void startCooldown(String message, int seconds) {
            this.cooldownMessage = message;
            this.cooldownEnd = System.currentTimeMillis() + (long)seconds * 1000L;
        }

        public boolean isInCooldownFor(String message) {
            return this.cooldownMessage != null && message.equalsIgnoreCase(this.cooldownMessage) && System.currentTimeMillis() < this.cooldownEnd;
        }

        public int getRemainingCooldown() {
            return (int)((this.cooldownEnd - System.currentTimeMillis()) / 1000L) + 1;
        }
    }
}

