/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Anti;

import dev.atrox.lightchat.HexColor;
import dev.atrox.lightchat.LightChat;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class AntiSpam
implements Listener {
    private final Map<UUID, Long> lastMessageTime = new HashMap<UUID, Long>();
    private final Map<UUID, Boolean> hasNotified = new HashMap<UUID, Boolean>();
    private int spamCooldownSeconds;
    private String cooldownMessage;
    private boolean opsBypassAntiSpam;
    private FileConfiguration messages;
    private final LightChat plugin;

    public AntiSpam(LightChat plugin) {
        this.plugin = plugin;
        this.reloadConfig();
    }

    public void reloadConfig() {
        FileConfiguration config = this.plugin.getConfig();
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
        this.spamCooldownSeconds = config.getInt("spam_cooldown_seconds", 2);
        this.cooldownMessage = this.plugin.getPrefixManager().formatMessage("antispam-cooldown");
        this.opsBypassAntiSpam = config.getBoolean("ops_bypass_anti_spam", true);
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        long lastMessage;
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (this.opsBypassAntiSpam && player.isOp()) {
            return;
        }
        long spamCooldownMillis = (long)this.spamCooldownSeconds * 1000L;
        long currentTime = System.currentTimeMillis();
        long timeLeftMillis = spamCooldownMillis - (currentTime - (lastMessage = this.lastMessageTime.getOrDefault(playerId, 0L).longValue()));
        if (timeLeftMillis > 0L) {
            event.setCancelled(true);
            if (!this.hasNotified.getOrDefault(playerId, false).booleanValue()) {
                long timeLeftSeconds = (long)Math.ceil((double)timeLeftMillis / 1000.0);
                String formattedMessage = this.cooldownMessage.replace("%cooldown_seconds%", String.valueOf(timeLeftSeconds));
                player.sendMessage(HexColor.translateAlternateColorCodes('&', formattedMessage));
                this.hasNotified.put(playerId, true);
            }
        } else {
            this.lastMessageTime.put(playerId, currentTime);
            this.hasNotified.put(playerId, false);
        }
    }
}

