/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Anti;

import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandSendEvent;
import org.bukkit.event.server.TabCompleteEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AntiTabComplete
implements Listener {
    private final JavaPlugin plugin;
    private List<String> unblockedTabComplete;
    private boolean opBypass;
    private boolean enabled;

    public AntiTabComplete(JavaPlugin plugin) {
        this.plugin = plugin;
        this.reloadConfig();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void reloadConfig() {
        File file = new File(this.plugin.getDataFolder(), "antitabcomplete.yml");
        if (!file.exists()) {
            this.plugin.saveResource("antitabcomplete.yml", false);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        this.unblockedTabComplete = config.getStringList("unblocked-tabcomplete");
        this.opBypass = config.getBoolean("op-bypass", true);
        this.enabled = config.getBoolean("enabled", true);
    }

    @EventHandler
    public void onPlayerCommandSend(PlayerCommandSendEvent event) {
        if (!this.enabled || this.opBypass && event.getPlayer().isOp()) {
            return;
        }
        Set allowedCommands = event.getCommands().stream().filter(command -> this.unblockedTabComplete.contains(command.toLowerCase())).collect(Collectors.toSet());
        event.getCommands().clear();
        event.getCommands().addAll(allowedCommands);
    }

    @EventHandler
    public void onTabComplete(TabCompleteEvent event) {
        if (!this.enabled || this.opBypass && event.getSender().isOp()) {
            return;
        }
        String buffer = event.getBuffer().toLowerCase().trim();
        if (buffer.startsWith("/")) {
            String command = buffer.split(" ")[0].substring(1);
            if (!this.unblockedTabComplete.contains(command)) {
                event.setCancelled(true);
            } else {
                List completions = event.getCompletions().stream().filter(completion -> {
                    String completionCommand = completion.split(" ")[0].substring(1).toLowerCase();
                    return this.unblockedTabComplete.contains(completionCommand);
                }).collect(Collectors.toList());
                event.setCompletions(completions);
            }
        }
    }
}

