/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Chat;

import dev.atrox.lightchat.Commands.Utils;
import dev.atrox.lightchat.HexColor;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AutoResponder
implements Listener {
    private final JavaPlugin plugin;
    private FileConfiguration config;
    private boolean enabled;
    private String prefix;
    private double responseChance;
    private Map<String, ResponseData> responses = new HashMap<String, ResponseData>();
    private Set<UUID> cooldown = Collections.synchronizedSet(new HashSet());
    private final long cooldownDuration = 20L;

    public AutoResponder(JavaPlugin plugin) {
        this.plugin = plugin;
        this.reloadConfig();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onChat(final AsyncPlayerChatEvent event) {
        if (!this.enabled || event.isCancelled()) {
            return;
        }
        final Player player = event.getPlayer();
        String message = event.getMessage().toLowerCase();
        if (this.cooldown.contains(player.getUniqueId())) {
            return;
        }
        Map.Entry<String, ResponseData> bestMatch = null;
        for (Map.Entry<String, ResponseData> entry : this.responses.entrySet()) {
            String trigger = entry.getKey();
            if (!message.equals(trigger) && !message.matches(".*\\b" + trigger + "\\b.*") || bestMatch != null && trigger.length() <= bestMatch.getKey().length()) continue;
            bestMatch = entry;
        }
        if (bestMatch == null) {
            return;
        }
        if (ThreadLocalRandom.current().nextDouble() > this.responseChance) {
            return;
        }
        this.cooldown.add(player.getUniqueId());
        new BukkitRunnable(){

            public void run() {
                AutoResponder.this.cooldown.remove(player.getUniqueId());
            }
        }.runTaskLater((Plugin)this.plugin, 20L);
        final ResponseData responseData = bestMatch.getValue();
        List<String> answers = responseData.getAnswers();
        if (answers.isEmpty()) {
            return;
        }
        final String response = answers.get(ThreadLocalRandom.current().nextInt(answers.size()));
        new BukkitRunnable(){

            public void run() {
                if (player.isOnline()) {
                    AutoResponder.this.sendFormattedResponse(player, response, responseData.isSendToAll() ? new HashSet(event.getRecipients()) : Collections.singleton(player));
                }
            }
        }.runTaskLater((Plugin)this.plugin, 3L);
    }

    private void sendFormattedResponse(Player player, String response, Collection<Player> recipients) {
        String location = String.format("X: %.0f, Y: %.0f, Z: %.0f", player.getLocation().getX(), player.getLocation().getY(), player.getLocation().getZ());
        String formatted = HexColor.translateAlternateColorCodes('&', this.prefix + response.replace("%player%", player.getName()).replace("%world%", player.getWorld().getName()).replace("%health%", String.valueOf((int)player.getHealth())).replace("%level%", String.valueOf(player.getLevel())).replace("%ping%", String.valueOf(Utils.getPlayerPing(player))).replace("%location%", location));
        for (Player p : recipients) {
            if (!p.isOnline()) continue;
            p.sendMessage(formatted);
        }
    }

    public void reloadConfig() {
        File configFile = new File(this.plugin.getDataFolder(), "autoresponder.yml");
        if (!configFile.exists()) {
            this.plugin.saveResource("autoresponder.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)configFile);
        this.enabled = this.config.getBoolean("enabled", true);
        this.prefix = this.config.getString("prefix", "&8[&6AI&8] &7");
        this.responseChance = this.config.getDouble("response-chance", 0.3);
        this.responses.clear();
        if (this.config.getConfigurationSection("responses") != null) {
            this.config.getConfigurationSection("responses").getKeys(false).forEach(key -> {
                List triggers = this.config.getStringList("responses." + key + ".triggers");
                List answers = this.config.getStringList("responses." + key + ".answers");
                boolean sendToAll = this.config.getBoolean("responses." + key + ".send-to-all", true);
                triggers.forEach(trigger -> this.responses.put(trigger.toLowerCase(), new ResponseData(answers, sendToAll)));
            });
        }
    }

    private static class ResponseData {
        private final List<String> answers;
        private final boolean sendToAll;

        public ResponseData(List<String> answers, boolean sendToAll) {
            this.answers = answers;
            this.sendToAll = sendToAll;
        }

        public List<String> getAnswers() {
            return this.answers;
        }

        public boolean isSendToAll() {
            return this.sendToAll;
        }
    }
}

