/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Chat;

import dev.atrox.lightchat.HexColor;
import dev.atrox.lightchat.LightChat;
import java.io.File;
import java.io.IOException;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class ChatDisable
implements CommandExecutor,
Listener {
    private final LightChat plugin;
    private FileConfiguration messages;
    private FileConfiguration data;
    private File dataFile;

    public ChatDisable(LightChat plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.reloadMessages();
        this.setupDataFile();
    }

    private void setupDataFile() {
        this.dataFile = new File(this.plugin.getDataFolder(), "data.yml");
        if (!this.dataFile.exists()) {
            try {
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.data = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    private void saveData() {
        try {
            this.data.save(this.dataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("lightchat.chatdisable")) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("no-permission"));
            return true;
        }
        this.data.set("chat.enabled", (Object)false);
        this.data.set("chat.disabled_by", (Object)sender.getName());
        this.saveData();
        String playerName = sender.getName();
        String disableMessage = this.plugin.getPrefixManager().formatMessage("chatdisable-message");
        if (disableMessage == null) {
            disableMessage = "";
        }
        disableMessage = disableMessage.replace("%player%", playerName);
        this.plugin.getServer().broadcastMessage(HexColor.translateAlternateColorCodes('&', disableMessage));
        return true;
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        Player player;
        if (!this.isChatEnabled() && !(player = event.getPlayer()).hasPermission("lightchat.bypass.chatdisable")) {
            event.setCancelled(true);
            player.sendMessage(this.plugin.getPrefixManager().formatMessage("chatdisable-blocked"));
        }
    }

    public boolean isChatEnabled() {
        return this.data.getBoolean("chat.enabled", true);
    }

    private void reloadMessages() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
    }
}

