/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Chat;

import dev.atrox.lightchat.HexColor;
import dev.atrox.lightchat.LightChat;
import java.io.File;
import java.io.IOException;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ChatEnable
implements CommandExecutor {
    private final LightChat plugin;
    private FileConfiguration messages;
    private FileConfiguration data;
    private File dataFile;

    public ChatEnable(LightChat plugin) {
        this.plugin = plugin;
        this.reloadMessages();
        this.setupDataFile();
    }

    private void setupDataFile() {
        this.dataFile = new File(this.plugin.getDataFolder(), "data.yml");
        if (!this.dataFile.exists()) {
            try {
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.data = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    private void saveData() {
        try {
            this.data.save(this.dataFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("lightchat.chatenable")) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("no-permission"));
            return true;
        }
        this.data.set("chat.enabled", (Object)true);
        this.data.set("chat.enabled_by", (Object)sender.getName());
        this.saveData();
        String playerName = sender.getName();
        String enableMessage = this.plugin.getPrefixManager().formatMessage("chatenable-message");
        if (enableMessage == null) {
            enableMessage = "";
        }
        enableMessage = enableMessage.replace("%player%", playerName);
        this.plugin.getServer().broadcastMessage(HexColor.translateAlternateColorCodes('&', enableMessage));
        return true;
    }

    private void reloadMessages() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
    }
}

