/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Chat;

import dev.atrox.lightchat.HexColor;
import java.io.File;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class JoinQuitMessage
implements Listener {
    private final JavaPlugin plugin;
    private FileConfiguration messages;
    private boolean enabled;
    private boolean chatEnabled;
    private boolean actionBarEnabled;

    public JoinQuitMessage(JavaPlugin plugin) {
        this.plugin = plugin;
        this.reloadConfig();
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        if (!this.enabled) {
            return;
        }
        Player player = e.getPlayer();
        String playerName = player.getName();
        String joinMessage = this.messages.getString("join-message", "&8[#caffbd+&8] #90fcab%player%");
        String formattedJoinMessage = HexColor.translateAlternateColorCodes('&', joinMessage.replace("%player%", playerName));
        if (this.chatEnabled) {
            e.setJoinMessage(formattedJoinMessage);
        } else {
            e.setJoinMessage(null);
        }
        if (this.actionBarEnabled) {
            for (Player online : this.plugin.getServer().getOnlinePlayers()) {
                if (online.getUniqueId().equals(player.getUniqueId())) continue;
                this.sendActionBar(online, formattedJoinMessage);
            }
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        if (!this.enabled) {
            return;
        }
        Player player = e.getPlayer();
        String playerName = player.getName();
        String quitMessage = this.messages.getString("quit-message", "&8[#ff0000-&8] #fc9090%player%");
        String formattedQuitMessage = HexColor.translateAlternateColorCodes('&', quitMessage.replace("%player%", playerName));
        if (this.chatEnabled) {
            e.setQuitMessage(formattedQuitMessage);
        } else {
            e.setQuitMessage(null);
        }
        if (this.actionBarEnabled) {
            for (Player online : this.plugin.getServer().getOnlinePlayers()) {
                if (online.getUniqueId().equals(player.getUniqueId())) continue;
                this.sendActionBar(online, formattedQuitMessage);
            }
        }
    }

    private void sendActionBar(Player player, String message) {
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
    }

    private void reloadConfig() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
        FileConfiguration config = this.plugin.getConfig();
        this.enabled = config.getBoolean("join-quit-messages.enabled", true);
        this.chatEnabled = config.getBoolean("join-quit-messages.type.chat", true);
        this.actionBarEnabled = config.getBoolean("join-quit-messages.type.actionbar", false);
    }
}

