/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Chat;

import dev.atrox.lightchat.Commands.DoNotDisturb;
import dev.atrox.lightchat.HexColor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.java.JavaPlugin;

public class Mention
implements Listener {
    private final JavaPlugin plugin;
    private final String title;
    private final String subtitle;
    private final String notificationSound;
    private final String mentionColor;

    public Mention(JavaPlugin plugin) {
        this.plugin = plugin;
        FileConfiguration config = plugin.getConfig();
        this.title = HexColor.translateAlternateColorCodes('&', config.getString("mention_notification.title", "&aYou've been mentioned"));
        this.subtitle = HexColor.translateAlternateColorCodes('&', config.getString("mention_notification.subtitle", "&7%player% mentioned you"));
        this.notificationSound = config.getString("mention_notification.sound", "ENTITY_EXPERIENCE_ORB_PICKUP").toUpperCase();
        this.mentionColor = HexColor.translateAlternateColorCodes('&', config.getString("mention_notification.color", "&9"));
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (!this.plugin.getConfig().getBoolean("mentions.enable", true)) {
            return;
        }
        String message = event.getMessage();
        Player sender = event.getPlayer();
        FileConfiguration config = this.plugin.getConfig();
        Pattern pattern = Pattern.compile("\\b(" + String.join((CharSequence)"|", (CharSequence[])Bukkit.getOnlinePlayers().stream().map(Player::getName).toArray(String[]::new)) + ")\\b", 2);
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            String mentionedPlayerName = matcher.group();
            Player mentionedPlayer = Bukkit.getPlayerExact((String)mentionedPlayerName);
            if (mentionedPlayer != null && mentionedPlayer.isOnline()) {
                if (!DoNotDisturb.isInDoNotDisturb(mentionedPlayer)) {
                    this.sendMentionNotification(sender, mentionedPlayer);
                } else if (config.getBoolean("dnd_modes.allow_mentions", true)) {
                    this.sendDndMentionMessage(sender, mentionedPlayer);
                } else if (config.getBoolean("dnd_modes.msg", true)) {
                    sender.sendMessage(HexColor.translateAlternateColorCodes('&', "&cPlayer " + mentionedPlayer.getName() + " is in Do Not Disturb mode and cannot be mentioned."));
                }
            }
            message = message.replaceAll("(?i)\\b" + Pattern.quote(mentionedPlayerName) + "\\b", this.mentionColor + mentionedPlayerName + HexColor.translateAlternateColorCodes('&', "&r"));
        }
        event.setMessage(message);
    }

    private void sendMentionNotification(Player sender, Player mentionedPlayer) {
        mentionedPlayer.sendTitle(this.title, this.subtitle.replace("%player%", sender.getDisplayName()), 10, 40, 10);
        try {
            Sound sound = Sound.valueOf((String)this.notificationSound.toUpperCase());
            mentionedPlayer.playSound(mentionedPlayer.getLocation(), sound, 1.0f, 1.0f);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid mention notification sound: " + this.notificationSound + ". Default sound will be used.");
            mentionedPlayer.playSound(mentionedPlayer.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        }
    }

    private void sendDndMentionMessage(Player sender, Player mentionedPlayer) {
        FileConfiguration config = this.plugin.getConfig();
        String senderMessage = HexColor.translateAlternateColorCodes('&', config.getString("dnd_modes.sender_message", "&cPlayer %player% is in Do Not Disturb mode and cannot be mentioned."));
        String mentionedPlayerMessage = HexColor.translateAlternateColorCodes('&', config.getString("dnd_modes.mentioned_message", "&7%player% mentioned you, but you are in Do Not Disturb mode."));
        sender.sendMessage(senderMessage.replace("%player%", mentionedPlayer.getName()));
        mentionedPlayer.sendMessage(mentionedPlayerMessage.replace("%player%", sender.getDisplayName()));
    }
}

