/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Chat;

import dev.atrox.lightchat.LightChat;
import java.io.File;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PlayerChatClear
implements CommandExecutor {
    private static final int MAX_MESSAGES = 100;
    private final LightChat plugin;
    private FileConfiguration messages;

    public PlayerChatClear(LightChat plugin) {
        this.plugin = plugin;
        this.reloadMessages();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("player-only"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("lightchat.pchatclear")) {
            player.sendMessage(this.plugin.getPrefixManager().formatMessage("no-permission"));
            return true;
        }
        this.clearChatForPlayer(player);
        player.sendMessage(this.plugin.getPrefixManager().formatMessage("playerchatclear-message"));
        return true;
    }

    private void clearChatForPlayer(Player player) {
        for (int i = 0; i < 100; ++i) {
            player.sendMessage(" ");
        }
    }

    private void reloadMessages() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
    }
}

