/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Chat;

import dev.atrox.lightchat.LightChat;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;

public class ToggleChat
implements CommandExecutor,
Listener {
    private final LightChat plugin;
    private final Set<Player> chatDisabledPlayers = new HashSet<Player>();
    private FileConfiguration messages;

    public ToggleChat(LightChat plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.reloadMessages();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("player-only"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("lightchat.togglechat")) {
            player.sendMessage(this.plugin.getPrefixManager().formatMessage("no-permission"));
            return true;
        }
        if (this.chatDisabledPlayers.contains(player)) {
            this.chatDisabledPlayers.remove(player);
            player.sendMessage(this.plugin.getPrefixManager().formatMessage("togglechat-enabled"));
        } else {
            this.chatDisabledPlayers.add(player);
            player.sendMessage(this.plugin.getPrefixManager().formatMessage("togglechat-disabled"));
        }
        return true;
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        Player sender = event.getPlayer();
        event.getRecipients().removeIf(this.chatDisabledPlayers::contains);
        if (this.chatDisabledPlayers.contains(sender)) {
            event.setCancelled(true);
            sender.sendMessage(this.plugin.getPrefixManager().formatMessage("togglechat-blocked"));
        }
    }

    private void reloadMessages() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
    }
}

