/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Chat;

import dev.atrox.lightchat.Chat.HexColor;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class WelcomeListener
implements Listener {
    private final JavaPlugin plugin;
    private FileConfiguration messagesConfig;
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private static final Map<String, String> HEAD_CACHE = new ConcurrentHashMap<String, String>();
    private static final ColorData[] COLOR_DATA;
    private static final ExecutorService HEAD_EXECUTOR;

    public WelcomeListener(JavaPlugin plugin) {
        this.plugin = plugin;
        this.loadMessagesConfig();
    }

    private void loadMessagesConfig() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.plugin.getConfig().getBoolean("welcome-message-enabled", true)) {
            return;
        }
        Player player = event.getPlayer();
        int onlineCount = this.plugin.getServer().getOnlinePlayers().size();
        CompletableFuture.runAsync(() -> {
            try {
                String head = this.getOrCreateHead(player);
                String message = this.formatMessage(player, onlineCount);
                List<String> finalMessage = this.mergeMessages(head, message);
                this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                    try {
                        this.sendWelcomeMessage(player, finalMessage);
                    }
                    catch (Exception e) {
                        this.handleError(player, e);
                    }
                });
            }
            catch (Exception e) {
                this.handleError(player, e);
            }
        }, HEAD_EXECUTOR);
    }

    private String getOrCreateHead(Player player) {
        return HEAD_CACHE.computeIfAbsent(player.getName(), k -> {
            try {
                return this.createHead(player);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Head creation error for " + player.getName(), e);
                return "";
            }
        });
    }

    private void sendWelcomeMessage(Player player, List<String> finalMessage) {
        for (String line : finalMessage) {
            if (line.contains("%discord%")) {
                this.handleDiscordLink(player, line);
                continue;
            }
            if (line.contains("%website%")) {
                this.handleWebsiteLink(player, line);
                continue;
            }
            player.sendMessage(HexColor.translateAlternateColorCodes('&', line));
        }
    }

    private void handleError(Player player, Exception e) {
        player.sendMessage(ChatColor.YELLOW + "Welcome to the server!");
        this.plugin.getLogger().log(Level.WARNING, "[LightChat] Welcome message error for " + player.getName(), e);
    }

    private void handleDiscordLink(Player player, String line) {
        String discordLink = this.messagesConfig.getString("welcome-message.discord-link", "discord.gg/example");
        String fullDiscordUrl = discordLink.startsWith("http") ? discordLink : "https://" + discordLink;
        String replaced = line.replace("%discord%", discordLink);
        String colored = HexColor.translateAlternateColorCodes('&', replaced);
        TextComponent discord = new TextComponent(colored);
        discord.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, fullDiscordUrl));
        String hoverText = HexColor.translateAlternateColorCodes('&', this.messagesConfig.getString("welcome-message.click-hover-text", "&eClick to open"));
        discord.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)hoverText)));
        player.spigot().sendMessage((BaseComponent)discord);
    }

    private void handleWebsiteLink(Player player, String line) {
        String websiteLink = this.messagesConfig.getString("welcome-message.website-link", "example.com");
        String fullWebsiteUrl = websiteLink.startsWith("http") ? websiteLink : "https://" + websiteLink;
        String replaced = line.replace("%website%", websiteLink);
        String colored = HexColor.translateAlternateColorCodes('&', replaced);
        TextComponent website = new TextComponent(colored);
        website.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, fullWebsiteUrl));
        String hoverText = HexColor.translateAlternateColorCodes('&', this.messagesConfig.getString("welcome-message.click-hover-text", "&eClick to open"));
        website.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)hoverText)));
        player.spigot().sendMessage((BaseComponent)website);
    }

    private List<String> mergeMessages(String head, String message) {
        String[] headLines = head.split("\n");
        String[] messageLines = message.split("\n");
        ArrayList<String> merged = new ArrayList<String>(Math.max(headLines.length, messageLines.length));
        int maxLines = Math.max(headLines.length, messageLines.length);
        for (int i = 0; i < maxLines; ++i) {
            StringBuilder line = new StringBuilder(64);
            if (i < headLines.length) {
                line.append(headLines[i]);
            }
            if (i < messageLines.length) {
                if (line.length() > 0) {
                    line.append("  ");
                }
                line.append(messageLines[i]);
            }
            merged.add(line.toString());
        }
        return merged;
    }

    private String formatMessage(Player player, int onlineCount) {
        String raw = this.messagesConfig.getString("welcome-message.message", "&#FFAA00\u00bb &eWelcome to &a%servername% &6\u00ab\n&7Players: &f%online%\n&7Date: &f%date%\n&7Website: &b%website%\n&7Discord: &9%discord%");
        return raw.replace("%online%", String.valueOf(onlineCount)).replace("%date%", DATE_FORMATTER.format(LocalDate.now())).replace("%player%", player.getName()).replace("%servername%", this.messagesConfig.getString("servername", this.plugin.getServer().getName())).replace("%discord%", "%discord%").replace("%website%", "%website%");
    }

    private String createHead(Player player) throws IOException {
        String urlString = "https://minotar.net/avatar/" + player.getName() + "/8.png";
        HttpURLConnection connection = (HttpURLConnection)new URL(urlString).openConnection();
        connection.setConnectTimeout(1500);
        connection.setReadTimeout(1500);
        connection.setRequestProperty("User-Agent", "LightChat/3.2");
        try {
            String string;
            block12: {
                InputStream inputStream = connection.getInputStream();
                try {
                    BufferedImage skin = ImageIO.read(inputStream);
                    if (skin == null || skin.getWidth() < 8 || skin.getHeight() < 8) {
                        throw new IOException("Invalid skin image dimensions");
                    }
                    StringBuilder head = new StringBuilder(64);
                    for (int y = 0; y < 8; ++y) {
                        for (int x = 0; x < 8; ++x) {
                            head.append(this.getClosestChatColor(skin.getRGB(x, y))).append("\u2588");
                        }
                        if (y >= 7) continue;
                        head.append("\n");
                    }
                    string = head.toString();
                    if (inputStream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return string;
        }
        finally {
            connection.disconnect();
        }
    }

    private ChatColor getClosestChatColor(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        ChatColor closest = ChatColor.WHITE;
        int minDistance = Integer.MAX_VALUE;
        for (ColorData data : COLOR_DATA) {
            int dr = r - data.r;
            int dg = g - data.g;
            int db = b - data.b;
            int distance = dr * dr + dg * dg + db * db;
            if (distance >= minDistance) continue;
            minDistance = distance;
            closest = data.color;
            if (distance == 0) break;
        }
        return closest;
    }

    private static int[] getColorValues(ChatColor color) {
        switch (color) {
            case BLACK: {
                return new int[]{0, 0, 0};
            }
            case DARK_BLUE: {
                return new int[]{0, 0, 170};
            }
            case DARK_GREEN: {
                return new int[]{0, 170, 0};
            }
            case DARK_AQUA: {
                return new int[]{0, 170, 170};
            }
            case DARK_RED: {
                return new int[]{170, 0, 0};
            }
            case DARK_PURPLE: {
                return new int[]{170, 0, 170};
            }
            case GOLD: {
                return new int[]{255, 170, 0};
            }
            case GRAY: {
                return new int[]{170, 170, 170};
            }
            case DARK_GRAY: {
                return new int[]{85, 85, 85};
            }
            case BLUE: {
                return new int[]{85, 85, 255};
            }
            case GREEN: {
                return new int[]{85, 255, 85};
            }
            case AQUA: {
                return new int[]{85, 255, 255};
            }
            case RED: {
                return new int[]{255, 85, 85};
            }
            case LIGHT_PURPLE: {
                return new int[]{255, 85, 255};
            }
            case YELLOW: {
                return new int[]{255, 255, 85};
            }
            case WHITE: {
                return new int[]{255, 255, 255};
            }
        }
        return new int[]{255, 255, 255};
    }

    static {
        ChatColor[] colors = new ChatColor[]{ChatColor.BLACK, ChatColor.DARK_BLUE, ChatColor.DARK_GREEN, ChatColor.DARK_AQUA, ChatColor.DARK_RED, ChatColor.DARK_PURPLE, ChatColor.GOLD, ChatColor.GRAY, ChatColor.DARK_GRAY, ChatColor.BLUE, ChatColor.GREEN, ChatColor.AQUA, ChatColor.RED, ChatColor.LIGHT_PURPLE, ChatColor.YELLOW, ChatColor.WHITE};
        COLOR_DATA = new ColorData[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            int[] rgb = WelcomeListener.getColorValues(colors[i]);
            WelcomeListener.COLOR_DATA[i] = new ColorData(colors[i], rgb[0], rgb[1], rgb[2]);
        }
        HEAD_EXECUTOR = Executors.newFixedThreadPool(2, r -> {
            Thread t = new Thread(r, "LightChat-HeadProcessor");
            t.setPriority(1);
            return t;
        });
    }

    private static class ColorData {
        final ChatColor color;
        final int r;
        final int g;
        final int b;

        ColorData(ChatColor color, int r, int g, int b) {
            this.color = color;
            this.r = r;
            this.g = g;
            this.b = b;
        }
    }
}

