/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Commands;

import dev.atrox.lightchat.HexColor;
import dev.atrox.lightchat.LightChat;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class AnnounceCommand
implements CommandExecutor {
    private final LightChat plugin;
    private FileConfiguration messages;
    private static final Pattern URL_PATTERN = Pattern.compile("(https?://[\\w.-]+\\.[a-z]{2,}(?:/[^\\s]*)?)");

    public AnnounceCommand(LightChat plugin) {
        this.plugin = plugin;
        plugin.getCommand("announce").setExecutor((CommandExecutor)this);
        this.reloadMessages();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', this.messages.getString("announce.usage", "&cUsage: /announce <message>")));
            return true;
        }
        String title = this.plugin.getConfig().getString("announce-title", "&eAnnouncement");
        String subtitle = this.plugin.getConfig().getString("announce-subtitle", "&bCheck the chat for details!");
        String prefix = this.plugin.getConfig().getString("announce-prefix", "&a[Announcer]");
        String soundName = this.plugin.getConfig().getString("announce-sound", "ENTITY_PLAYER_LEVELUP");
        Sound sound = Sound.valueOf((String)soundName.toUpperCase());
        String message = String.join((CharSequence)" ", args);
        String formattedTitle = HexColor.translateAlternateColorCodes('&', title);
        String formattedSubtitle = HexColor.translateAlternateColorCodes('&', subtitle);
        String formattedPrefix = HexColor.translateAlternateColorCodes('&', prefix);
        String formattedMessage = HexColor.translateAlternateColorCodes('&', message);
        List<BaseComponent[]> messageComponents = this.processMessage(formattedPrefix, formattedMessage);
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendTitle(formattedTitle, formattedSubtitle, 10, 70, 20);
            player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
            for (BaseComponent[] component : messageComponents) {
                player.spigot().sendMessage(component);
            }
        }
        return true;
    }

    private List<BaseComponent[]> processMessage(String prefix, String message) {
        ArrayList<BaseComponent[]> components = new ArrayList<BaseComponent[]>();
        components.add(new BaseComponent[]{new TextComponent("")});
        TextComponent prefixLine = new TextComponent(TextComponent.fromLegacyText((String)this.centerText(prefix)));
        components.add(new BaseComponent[]{prefixLine});
        components.add(new BaseComponent[]{new TextComponent("")});
        List<String> messageLines = this.splitMessage(message);
        for (String line : messageLines) {
            TextComponent messageLine = new TextComponent(TextComponent.fromLegacyText((String)this.centerText(line)));
            components.add(new BaseComponent[]{messageLine});
        }
        components.add(new BaseComponent[]{new TextComponent("")});
        return components;
    }

    private List<String> splitMessage(String message) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = message.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (currentLine.length() + word.length() + 1 > 50) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder();
            }
            if (currentLine.length() > 0) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    private String centerText(String text) {
        int maxWidth = 50;
        int textLength = text.replaceAll("\u00a7[0-9a-fk-or]", "").length();
        int spaces = (maxWidth - textLength) / 2;
        StringBuilder centered = new StringBuilder();
        for (int i = 0; i < spaces; ++i) {
            centered.append(" ");
        }
        centered.append(text);
        return centered.toString();
    }

    private BaseComponent[] createClickableComponents(String text) {
        Matcher matcher = URL_PATTERN.matcher(text);
        ArrayList<TextComponent> components = new ArrayList<TextComponent>();
        int lastEnd = 0;
        String hoverText = HexColor.translateAlternateColorCodes('&', this.messages.getString("announce-link-hover", "&eClick to open announcement link: &6%url%"));
        while (matcher.find()) {
            if (matcher.start() > lastEnd) {
                String before = text.substring(lastEnd, matcher.start());
                components.add(new TextComponent(TextComponent.fromLegacyText((String)before)));
            }
            String url = matcher.group();
            TextComponent urlComponent = new TextComponent(TextComponent.fromLegacyText((String)url));
            urlComponent.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
            urlComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)hoverText.replace("%url%", url))));
            components.add(urlComponent);
            lastEnd = matcher.end();
        }
        if (lastEnd < text.length()) {
            components.add(new TextComponent(TextComponent.fromLegacyText((String)text.substring(lastEnd))));
        }
        return components.toArray(new BaseComponent[0]);
    }

    private void reloadMessages() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
    }
}

