/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Commands;

import dev.atrox.lightchat.HexColor;
import dev.atrox.lightchat.LightChat;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class BroadCastCommand
implements CommandExecutor {
    private final LightChat plugin;
    private FileConfiguration messages;
    private static final Pattern URL_PATTERN = Pattern.compile("(https?://[\\w.-]+\\.[a-z]{2,}(?:/[^\\s]*)?)");

    public BroadCastCommand(LightChat plugin) {
        this.plugin = plugin;
        plugin.getCommand("broadcast").setExecutor((CommandExecutor)this);
        this.reloadMessages();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', this.messages.getString("broadcast-usage")));
            return true;
        }
        String prefix = this.plugin.getConfig().getString("broadcast-prefix", "&6[Broadcast]");
        String message = String.join((CharSequence)" ", args);
        String formattedPrefix = HexColor.translateAlternateColorCodes('&', prefix);
        String formattedMessage = HexColor.translateAlternateColorCodes('&', message);
        TextComponent broadcastComponent = this.createClickableComponent(formattedPrefix + " " + formattedMessage);
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.spigot().sendMessage((BaseComponent)broadcastComponent);
        }
        return true;
    }

    private TextComponent createClickableComponent(String text) {
        Matcher matcher = URL_PATTERN.matcher(text);
        TextComponent component = new TextComponent("");
        while (matcher.find()) {
            String url = matcher.group();
            String beforeUrl = text.substring(0, matcher.start());
            String hoverText = HexColor.translateAlternateColorCodes('&', this.messages.getString("broadcast-link-hover").replace("%url%", url));
            if (!beforeUrl.isEmpty()) {
                component.addExtra((BaseComponent)new TextComponent(TextComponent.fromLegacyText((String)beforeUrl)));
            }
            TextComponent urlComponent = new TextComponent(TextComponent.fromLegacyText((String)url));
            urlComponent.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
            urlComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (BaseComponent[])new TextComponent[]{new TextComponent(TextComponent.fromLegacyText((String)hoverText))}));
            component.addExtra((BaseComponent)urlComponent);
            text = text.substring(matcher.end());
            matcher = URL_PATTERN.matcher(text);
        }
        if (!text.isEmpty()) {
            component.addExtra((BaseComponent)new TextComponent(TextComponent.fromLegacyText((String)text)));
        }
        return component;
    }

    private void reloadMessages() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
    }
}

