/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Commands;

import dev.atrox.lightchat.HexColor;
import dev.atrox.lightchat.LightChat;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class LiveCommand
implements CommandExecutor,
TabCompleter {
    private final LightChat plugin;
    private FileConfiguration config;
    private FileConfiguration messages;

    public LiveCommand(LightChat plugin) {
        this.plugin = plugin;
        this.reloadConfigs();
        plugin.getCommand("live").setExecutor((CommandExecutor)this);
        plugin.getCommand("live").setTabCompleter((TabCompleter)this);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String link;
        String platform;
        if (!this.config.getBoolean("live.enabled", true)) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', this.messages.getString("live.disabled", "&cLive feature is disabled.")));
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', this.messages.getString("live.usage", "&cUsage: /live <platform> or /live link <custom_link>")));
            return true;
        }
        if (args[0].equalsIgnoreCase("link")) {
            if (args.length < 2) {
                sender.sendMessage(HexColor.translateAlternateColorCodes('&', this.messages.getString("live.usage", "&cUsage: /live link <custom_link>")));
                return true;
            }
            platform = "Custom";
            link = args[1];
        } else {
            platform = args[0].toLowerCase();
            if (args.length >= 2) {
                link = args[1];
            } else {
                link = this.config.getString("live.platforms." + platform);
                if (link == null) {
                    String platforms = String.join((CharSequence)", ", this.config.getConfigurationSection("live.platforms").getKeys(false));
                    sender.sendMessage(HexColor.translateAlternateColorCodes('&', this.messages.getString("live.invalid_platform", "&cInvalid platform. Available platforms: %platforms%").replace("%platforms%", platforms)));
                    return true;
                }
            }
        }
        this.sendLiveMessage(link, platform);
        return true;
    }

    private void sendLiveMessage(String link, String platform) {
        String subtitle;
        String prefix = HexColor.translateAlternateColorCodes('&', this.messages.getString("live.prefix", "&a[Live] "));
        boolean titleEnabled = this.config.getBoolean("live.title_enabled", true);
        boolean subtitleEnabled = this.config.getBoolean("live.subtitle_enabled", true);
        String title = titleEnabled ? this.messages.getString("live.title", "") : "";
        String string = subtitle = subtitleEnabled ? this.messages.getString("live.subtitle", "") : "";
        if (!title.isEmpty() || !subtitle.isEmpty()) {
            String formattedTitle = title.replace("%liveprefix%", prefix).replace("%livelink%", link).replace("%platform%", platform);
            formattedTitle = HexColor.translateAlternateColorCodes('&', formattedTitle);
            Object formattedSubtitle = subtitle.replace("%liveprefix%", prefix).replace("%livelink%", link).replace("%platform%", platform);
            formattedSubtitle = HexColor.translateAlternateColorCodes('&', (String)formattedSubtitle);
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.sendTitle(formattedTitle, (String)formattedSubtitle, 10, 70, 20);
            }
        }
        List messageTemplate = this.messages.getStringList("live.message");
        for (String line : messageTemplate) {
            String formattedLine = line.replace("%liveprefix%", prefix).replace("%livelink%", link).replace("%platform%", platform);
            formattedLine = HexColor.translateAlternateColorCodes('&', formattedLine);
            TextComponent messageComponent = new TextComponent(TextComponent.fromLegacyText((String)formattedLine));
            String hoverMessage = this.messages.getString("live.link-hover", "&eClick to open live stream: &6%url%").replace("%url%", link);
            hoverMessage = HexColor.translateAlternateColorCodes('&', hoverMessage);
            BaseComponent[] hoverComponents = TextComponent.fromLegacyText((String)hoverMessage);
            messageComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, hoverComponents));
            messageComponent.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, link));
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.spigot().sendMessage((BaseComponent)messageComponent);
            }
        }
        String soundName = this.config.getString("live.sound", "ENTITY_PLAYER_LEVELUP");
        if (soundName != null && !soundName.isEmpty()) {
            try {
                Sound sound = Sound.valueOf((String)soundName.toUpperCase());
                for (Player player : Bukkit.getOnlinePlayers()) {
                    player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
                }
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid sound name in config.yml: " + soundName);
            }
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>(this.config.getConfigurationSection("live.platforms").getKeys(false));
            suggestions.add("link");
            return suggestions.stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        return null;
    }

    private void reloadConfigs() {
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.plugin.saveResource("config.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)configFile);
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
    }
}

