/*
 * Decompiled with CFR 0.152.
 */
package dev.atrox.lightchat.Commands;

import dev.atrox.lightchat.Commands.Utils;
import dev.atrox.lightchat.HexColor;
import dev.atrox.lightchat.LightChat;
import java.io.File;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PingCommand
implements CommandExecutor {
    private final LightChat plugin;
    private FileConfiguration messages;

    public PingCommand(LightChat plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', this.getMessage("player-only")));
            return true;
        }
        Player player = (Player)sender;
        int ping = Utils.getPlayerPing(player);
        if (ping == -1) {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', this.getMessage("ping-error")));
        } else {
            sender.sendMessage(HexColor.translateAlternateColorCodes('&', this.formatPingMessage(ping)));
        }
        return true;
    }

    private String formatPingMessage(int ping) {
        String message = ping <= 50 ? this.getMessage("ping-excellent") : (ping <= 100 ? this.getMessage("ping-good") : (ping <= 200 ? this.getMessage("ping-medium") : this.getMessage("ping-bad")));
        return message.replace("%ping%", String.valueOf(ping));
    }

    private String getMessage(String key) {
        return this.messages.getString(key, "&cMessage not found: " + key);
    }

    private void loadMessages() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
        this.verifyMessages();
    }

    private void verifyMessages() {
        String[] requiredMessages;
        for (String key : requiredMessages = new String[]{"player-only", "ping-error", "ping-excellent", "ping-good", "ping-medium", "ping-bad"}) {
            if (this.messages.contains(key)) continue;
            this.plugin.getLogger().warning("Missing message in messages.yml: " + key);
        }
    }
}

